#!/bin/sh

if [ "$1" = "-p" ]; then
	shift; exec 3>&2
else
	exec 3> /dev/null
fi

if [ "$1" = "-v" ]; then
	shift
else
	exec 2> /dev/null
fi

cc_lang="c"
cc_main=""
retcode="0"
result=""

test_prog() {
	if echo "$1" | $CC $CFLAGS $LDFLAGS $2 \
		-x $cc_lang - -o $tmpfile >&2
	then result=1; else result=0; fi
}

test_header() {
	local includes=""
	for hdr in $1; do
		includes="$includes
			#include <$hdr>"
	done; shift
	test_prog "$includes
		int main() { $cc_main return 0; }" "$@"
}

{
	echo "SYSTEM  = $1"
	echo "CC      = $CC"
	echo "CXX     = $CXX"
	echo "CFLAGS  = $CFLAGS"
	echo "LDFLAGS = $LDFLAGS"
} >&2

if [ -f config.cache ]; then
	. ./config.cache
	eval "cached_result=\$cached_syscheck_result_$1"
	if [ -n "$cached_result" ]; then
		echo $cached_result
		exit $retcode
	fi
fi

tmpfile=`mktemp /tmp/spl_syscheck.XXXXXX`

echo -n "Checking for $1:" >&3

case "$1" in
	pcre)
		test_header "pcre.h" "$(pcre-config --cflags)"
		;;
	expat)
		test_header "expat.h"
		;;
	sqlite)
		test_header "sqlite3.h"
		;;
	mysql)
		test_header "mysql/mysql.h"
		;;
	postgres)
		test_header "libpq-fe.h" "-I$(pg_config --includedir)/."
		;;
	libxml2)
		test_header "libxml/parser.h" "$(xml2-config --cflags)"
		;;
	libxslt)
		test_header "libexslt/exslt.h" "$(xslt-config --cflags)"
		;;
	libsdl)
		test_header "SDL/SDL_image.h" "$(sdl-config --cflags)"
		;;
	libcurl)
		cc_main="if (CURLOPT_FTP_ACCOUNT != 0) {}";
		test_header "curl/curl.h" "$(curl-config --cflags)"
		;;
	libuuid)
		test_header "uuid/uuid.h" "-luuid"
		;;
	libfann)
		if pkg-config --silence-errors --modversion fann | grep -qx '2.0.0'
		then result=1; else result=0; fi
		;;
	libsmoke)
		cc_lang="c++"; CC="$CXX"
		CFLAGS="`echo $CFLAGS | sed 's,-std=gnu99,,'`"
		test_header "smoke.h"
		;;
	libsmoke_config)
		echo "#include <smoke.h>" | $CC $CFLAGS -E - > $tmpfile
		grep -q mf_ctor $tmpfile || echo "-DSMOKE_WITHOUT_MF_CTOR"
		;;
	readline)
		test_header "stdio.h readline/readline.h"
		;;
	gettext_libc)
		if $CC -o $tmpfile -x c - >&2 <<- EOT
			#include <locale.h>
			#include <libintl.h>
			int main() {
			  textdomain(0);
			  return 0;
			}
		EOT
		then result=1; else result=0; fi
		;;
	gettext_intl)
		if $CC -o $tmpfile -x c - -lintl >&2 <<- EOT
			#include <locale.h>
			#include <libintl.h>
			int main() {
			  textdomain(0);
			  return 0;
			}
		EOT
		then result=1; else result=0; fi
		;;
	pthread)
		if $CC -pthread -o $tmpfile -x c - >&2 <<- EOT
			#include <pthread.h>
			int main() {
			  pthread_t foobar;
			  pthread_create(&foobar, 0, 0, 0);
			  return 0;
			}
		EOT
		then result=1; else result=0; fi
		;;
	extra_cflags)
		for dir in \
			/usr/include/{kde,qt3}				\
			/opt/{kde*,qt3*,mysql}/include			\
			/usr/lib{,32,64}/qt*/include			\
			/{usr,opt}/local/include
		do
			[ -d $dir ] && echo "-I$dir"
		done
		;;
	extra_ldflags)
		for dir in \
			/opt/{kde*,qt*,mysql}/lib{,32,64}		\
			/usr/lib{,32,64}/{qt*/lib,mysql}		\
			/{usr,opt}/local/lib{,32,64}
		do
			[ -d $dir ] && echo "-L$dir"
		done
		;;
	*)
		echo "Usage: $0 {mode}"
		retcode=1
esac

if [ "$result" = "0" -o "$result" = "1" ]; then
	echo "cached_syscheck_result_$1=$result" >> config.cache
	[ "$result" = "0" ] && echo " not found." >&3
	[ "$result" = "1" ] && echo " found." >&3
else
	echo " done." >&3
fi

if [ -n "$result" ]; then
	echo $result
fi

rm -f $tmpfile
exit $retcode

