/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  webspl_common.h: Common functions for webspl.c and webspld
 */

#ifndef SPL_WEBSPL_COMMON_H
#define SPL_WEBSPL_COMMON_H


/* mod_cgi.c definitions */

struct cgi_params_t {
	struct cgi_params_t *next;
	char *key, *value, *file_data;
	int file_size;
};

struct cgi_cookie_t {
	struct cgi_cookie_t *next;
	char *key, *value;
};

struct http_request_hdr {
	char *name, *value;
	struct http_request_hdr *next;
};

struct http_request {
	char *method, *url, *query, *pver, *peerip;
	struct http_request_hdr *headers;
	char *data, *data_type;
	int data_len;
};

struct cgi_config_item {
	char *name, *value;
	struct cgi_config_item *next;
};

struct cgi_config {
	char *configfile, *scriptpath;
	struct cgi_config_item *items;
};

struct cgi_context {
	struct cgi_params_t *params;
	struct cgi_cookie_t *cookies;

	char *content_type;
	char *session;

	char *url;
	char *agent;
	char *peerip;

	char *post_type;
	char *post_data;

	int report_count;
	int silent_debug;

	FILE *outfile;
	struct http_request *req;

	struct cgi_config *config;
};

extern struct cgi_context *spl_mod_cgi_get_cgi_ctx(struct http_request *req, struct cgi_config *cfg);
extern void spl_mod_cgi_free_cgi_ctx(struct cgi_context *ctx);

extern struct spl_node *spl_mod_cgi_write(struct spl_task *task, void *data);
extern void spl_mod_cgi_reportfunc(int type, void *desc, const char *fmt, ...);


/* webspl_common.c functions */

// expire old dump files after 4 hours
#define EXPIRE_DUMPDIR_TIMEOUT (60*60*4)

// check for expired files every 5 minutes
#define EXPIRE_DUMPDIR_INTERVAL 300

extern void create_dumpdir(const char *basedir);
extern void expire_dumpdir(const char *basedir, int timeout, int interval);
extern char *get_new_session();

#define WEBSPL_CONFIG_NAME "webspl.conf"
extern struct cgi_config *cgi_config_read(char *path);
extern void cgi_config_free(struct cgi_config *cfg);

static inline int cgi_config_get_int(struct cgi_config *cfg, const char *name)
{
	if (cfg) {
		struct cgi_config_item *i = cfg->items;
		while (i) {
			if (!strcmp(i->name, name))
				return atoi(i->value);
			i = i->next;
		}
	}
	return 0;
}

static inline const char *cgi_config_get_str(struct cgi_config *cfg, const char *name)
{
	if (cfg) {
		struct cgi_config_item *i = cfg->items;
		while (i) {
			if (!strcmp(i->name, name))
				return i->value;
			i = i->next;
		}
	}
	return 0;
}


/* httpsrv.c functions */

extern void handle_http_request(int fd,
	struct spl_vm *(*vm_pool_get)(const char *session, int create),
	void (*vm_pool_put)(struct spl_vm *vm),
	struct spl_code *(*filename_to_codepage)(struct spl_vm *vm, const char *file));

#endif

