#ifndef GRAPH2D_H

#ifdef HAVE_CONFIG_H
#include "config.H"
#endif

#ifdef __GNUC__
#  pragma interface
#endif

typedef double greal;
typedef double real;

enum {Ncolors=256, max_selected_xticks=100};
enum TMinorTicks {MINORTICKS_FALSE, MINORTICKS_TRUE, MINORTICKS_AUTO};

extern greal selected_xticks[max_selected_xticks];
extern greal selected_xticks_uvalues[max_selected_xticks];
extern int N_selected_xticks;

inline int limit(int x, int a, int b)
{
	if (x < a) return a;
	if (x > b) return b;
	return x;
}

class Tgraph2D {
public:
	enum TFontType {FONT_AXISLABEL, FONT_ANNOTATION, FONT_TOPLABEL, FONT_SIDELABEL, FONT_COPYRIGHT};
	enum TLineType {LINE_NONE, LINE_SOLID,
					LINE_DOTTED, LINE_DASHED, LINE_DOTDASHED,
					LINE_GRIDDOTTED};
	enum TPaletteType {PALETTE_RAINBOW, PALETTE_GRAYSCALE};
protected:
	TLineType linetype_set;
public:
	Tgraph2D() :linetype_set(LINE_SOLID) {}
	virtual void begin_line(greal x, greal y) = 0;
	virtual void vertex(greal x1, greal y1) = 0;
	virtual void end_line() = 0;
	virtual void begin_fill(greal x, greal y) = 0;
	virtual void end_fill() = 0;
	virtual bool polygons_always_convex() const = 0;
	virtual void point(greal x, greal y) = 0;
	virtual void circle(greal x, greal y, greal r) = 0;
	virtual void fillcircle(greal x, greal y, greal r) = 0;
	virtual void text(greal x, greal y, const char *s, int Xoffset, int Yoffset, bool rotate=false) = 0;
	virtual void text_exponent(greal x, greal y, const char *mant, const char *expo, int Xoffset, int Yoffset) = 0;
	virtual void comment(greal x, greal y) = 0;
	virtual void comment(const char *s) = 0;
	virtual void setfont(TFontType) = 0;
	virtual void setlinewidth(greal lw) = 0;
	virtual void setlinetype(TLineType) = 0;
	virtual void setcolor(const greal rgb[3]) = 0;
	virtual void setcolor(int) = 0;		// indexed color, can use after calling setpalette only
	virtual void begin_clipped(greal x1, greal y1, greal x2, greal y2) = 0;
	virtual void end_clipped() = 0;
	virtual void fillrrect(greal x1, greal y1, greal dx, greal dy) = 0;
	virtual void fillrrect_interp(greal x1, greal y1, greal dx, greal dy, int u1, int u2, int u3, int u4) = 0;
	virtual void setpalette(const int [3][Ncolors]) = 0;
	virtual void gsave() = 0;
	virtual void grestore() = 0;
	void setpalette(TPaletteType p);
	TLineType getlinetype() const {return linetype_set;}
	void line(greal x1, greal y1, greal x2, greal y2) {begin_line(x1,y1); vertex(x2,y2); end_line();}
	void rect(greal x1, greal y1, greal x2, greal y2);
	void rrect(greal x1, greal y1, greal dx, greal dy) {rect(x1,y1,x1+dx,y1+dy);}
	void curve(int n, const real x[], const real y[],
			   greal x1, greal y1, greal x2, greal y2,			// rect where to draw
			   greal xmin, greal xmax, greal ymin, greal ymax,	// wanted min,max of x,y
			   int markertype, greal markersize
		);
	void filledcurve(int n, const real x[], const real y[],
					 greal x1, greal y1, greal x2, greal y2,			// rect where to draw
					 greal xmin, greal xmax, greal ymin, greal ymax		// wanted min,max of x,y
		);
	void pcolor(int nx, const real x[],		// x-vector, length nx
				int ny, const real y[],		// y-vector, length ny
				const real z[],				// z-matrix, size nx x ny
				greal zmin, greal zmax,		// found (or set) min,max of z-matrix
				greal x1, greal y1, greal x2, greal y2,			// rect where to draw
				greal xmin, greal xmax, greal ymin, greal ymax,	// wanted min,max of x,y
				bool interp, bool ghosts_only=false
				);
	void axis(greal x1, greal y1,
			  greal x2, greal y2,
			  greal dx, greal dy,
			  bool logaxis,
			  real u1, real u2,
			  bool include_label, bool houraxis,
			  TMinorTicks include_finer=MINORTICKS_AUTO);
	int DrawAxis1(greal x1, greal y1,
				  greal x2, greal y2,
				  greal dx, greal dy,
				  bool logaxis,
				  real u1, real u2,
				  int level,
				  bool labels, bool houraxis, bool actually_draw);
	void mark(greal x, greal y, int type, greal size);
	virtual ~Tgraph2D() {}
};

#define GRAPH2D_H

#endif
