<?php
/**
 * Administrator plugin - Option definitions
 *
 * @version $Id: defines.php,v 1.32.2.9 2004/12/28 10:37:09 tokul Exp $
 * @author Philippe Mingo
 * @copyright (c) 1999-2005 The SquirrelMail Project Team
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 * @package plugins
 * @subpackage administrator
 */

/** */
require_once( SM_PATH . 'functions/constants.php' );

/* Define constants for the various option types. */
define('SMOPT_TYPE_UNDEFINED', -1);
define('SMOPT_TYPE_STRING', 0);
define('SMOPT_TYPE_STRLIST', 1);
define('SMOPT_TYPE_TEXTAREA', 2);
define('SMOPT_TYPE_INTEGER', 3);
define('SMOPT_TYPE_FLOAT', 4);
define('SMOPT_TYPE_BOOLEAN', 5);
define('SMOPT_TYPE_HIDDEN', 6);
define('SMOPT_TYPE_COMMENT', 7);
define('SMOPT_TYPE_NUMLIST', 8);
define('SMOPT_TYPE_TITLE', 9);
define('SMOPT_TYPE_THEME', 10);
define('SMOPT_TYPE_PLUGINS', 11);
define('SMOPT_TYPE_LDAP', 12);
define('SMOPT_TYPE_EXTERNAL', 32);
define('SMOPT_TYPE_PATH',33);

global $languages;

$language_values = array( );
foreach ($languages as $lang_key => $lang_attributes) {
    if (isset($lang_attributes['NAME'])) {
        $language_values[$lang_key] = $lang_attributes['NAME'];
    }
}
asort( $language_values );
$language_values = array_merge(array('' => _("Default")), $language_values);
$left_size_values = array();
for ($lsv = 100; $lsv <= 300; $lsv += 10) {
    $left_size_values[$lsv] = "$lsv " . _("pixels");
}

$defcfg = array( '$config_version' => array( 'name' => _("Config File Version"),
                                             'type' => SMOPT_TYPE_COMMENT,
                                             'size' => 7 ),
                 'SM_ver' => array( 'name' => _("SquirrelMail Version"),
                                    'type' => SMOPT_TYPE_EXTERNAL,
                                    'value' => "$version" ),
                 'PHP_ver' => array( 'name' => _("PHP Version"),
                                     'type' => SMOPT_TYPE_EXTERNAL,
                                     'value' => phpversion() ),
                 /* --------------------------------------------------------*/
                 'Group1' => array( 'name' => _("Organization Preferences"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$org_name' => array( 'name' => _("Organization Name"),
                                       'type' => SMOPT_TYPE_STRING,
                                       'size' => 40 ),
                 '$org_logo' => array( 'name' => _("Organization Logo"),
                                       'type' => SMOPT_TYPE_PATH,
                                       'size' => 40,
                                       'default' => '../images/sm_logo.png'),
                 '$org_logo_width' => array( 'name'    => _("Organization Logo Width"),
                                             'type'    => SMOPT_TYPE_STRING,
                                             'size'    => 5,
                                             'default' => 0),
                 '$org_logo_height' => array( 'name'    => _("Organization Logo Height"),
                                              'type'    => SMOPT_TYPE_STRING,
                                              'size'    => 5,
                                              'default' => 0),
                 '$org_title' => array( 'name' => _("Organization Title"),
                                        'type' => SMOPT_TYPE_STRING,
                                        'size' => 40 ),
                 '$signout_page' => array( 'name' => _("Signout Page"),
                                           'type' => SMOPT_TYPE_PATH,
                                           'size' => 40 ),
                 '$provider_uri' => array( 'name' => _("Provider Link URI"),
                                           'type' => SMOPT_TYPE_STRING ),
                 '$provider_name' => array( 'name' => _("Provider Name"),
                                            'type' => SMOPT_TYPE_STRING ),
                 '$frame_top' => array( 'name' => _("Top Frame"),
                                        'type' => SMOPT_TYPE_STRING,
                                        'size' => 40,
                                        'default' => '_top' ),
                 /* --------------------------------------------------------*/
                 'Group2' => array( 'name' => _("Server Settings"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$domain' => array( 'name' => _("Mail Domain"),
                                     'type' => SMOPT_TYPE_STRING,
                                     'size' => 40 ),
                 '$imapServerAddress' => array( 'name' => _("IMAP Server Address"),
                                                'type' => SMOPT_TYPE_STRING,
                                                'size' => 40 ),
                 '$imapPort' => array( 'name' => _("IMAP Server Port"),
                                       'type' => SMOPT_TYPE_INTEGER ),
                 '$imap_server_type' => array( 'name' => _("IMAP Server Type"),
                                               'type' => SMOPT_TYPE_STRLIST,
                                               'posvals' => array( 'cyrus' => _("Cyrus IMAP server"),
                                                                   'uw' => _("University of Washington's IMAP server"),
                                                                   'exchange' => _("Microsoft Exchange IMAP server"),
                                                                   'courier' => _("Courier IMAP server"),
                                                                   'macosx' => _("Mac OS X Mailserver"),
                                                                   'hmailserver' => _("hMailServer IMAP server"),
                                                                   'other' => _("Not one of the above servers") ) ),
                 '$optional_delimiter' => array( 'name' => _("IMAP Folder Delimiter"),
                                                 'type' => SMOPT_TYPE_STRING,
                                                 'comment' => _("Use &quot;detect&quot; to auto-detect."),
                                                 'size' => 10,
                                                 'default' => 'detect' ),
                 '$use_imap_tls' => array( 'name' => _("Use TLS for IMAP Connections"),
                                           'type' => SMOPT_TYPE_BOOLEAN,
                                           'comment' => _("Requires PHP 4.3.x! Experimental."),
                                           'default' => false ),
                 '$imap_auth_mech' => array( 'name' => _("IMAP Authentication Type"),
                                             'type' => SMOPT_TYPE_STRLIST,
                                             'posvals' => array('login' => _("IMAP login"),
                                                                'cram-md5' => 'CRAM-MD5',
                                                                'digest-md5' => 'DIGEST-MD5'),
                                             'default' => 'login' ),
                 '$useSendmail' => array( 'name' => _("Use Sendmail Binary"),
                                          'type' => SMOPT_TYPE_BOOLEAN,
                                          'comment' => _("Choose &quot;no&quot; for SMTP") ),
                 '$sendmail_path' => array( 'name' => _("Sendmail Path"),
                                            'type' => SMOPT_TYPE_STRING,
                                            'size' => 40 ),
                 '$smtpServerAddress' => array( 'name' => _("SMTP Server Address"),
                                                'type' => SMOPT_TYPE_STRING,
                                                'size' => 40 ),
                 '$smtpPort' => array( 'name' => _("SMTP Server Port"),
                                       'type' => SMOPT_TYPE_INTEGER ),
                 '$use_smtp_tls' => array( 'name' => _("Use TLS for SMTP Connections"),
                                           'type' => SMOPT_TYPE_BOOLEAN,
                                           'comment' => _("Requires PHP 4.3.x! Experimental."),
                                           'default' => false ),
                 '$smtp_auth_mech' => array( 'name' => _("SMTP Authentication Type"),
                                             'type' => SMOPT_TYPE_STRLIST,
                                             'posvals' => array('none' => _("No SMTP auth"),
                                                                'login' => _("Login (plain text)"),
                                                                'cram-md5' => 'CRAM-MD5',
                                                                'digest-md5' => 'DIGEST-MD5'),
                                             'default' => 'none'),
                 '$pop_before_smtp' => array( 'name' => _("POP3 Before SMTP?"),
                                              'type' => SMOPT_TYPE_BOOLEAN,
                                              'default' => false ),
                 '$invert_time' => array( 'name' => _("Invert Time"),
                                          'type' => SMOPT_TYPE_BOOLEAN ),
                 /* --------------------------------------------------------*/
                 'Group3' => array( 'name' => _("Folders Defaults"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$default_folder_prefix' => array( 'name' => _("Default Folder Prefix"),
                                                    'type' => SMOPT_TYPE_STRING,
                                                    'size' => 40 ),
                 '$show_prefix_option' => array( 'name' => _("Show Folder Prefix Option"),
                                                 'type' => SMOPT_TYPE_BOOLEAN ),
                 '$trash_folder' => array( 'name' => _("Trash Folder"),
                                           'type' => SMOPT_TYPE_STRING,
                                           'size' => 40 ),
                 '$sent_folder' => array( 'name' => _("Sent Folder"),
                                          'type' => SMOPT_TYPE_STRING,
                                          'size' => 40 ),
                 '$draft_folder' => array( 'name' => _("Draft Folder"),
                                           'type' => SMOPT_TYPE_STRING,
                                           'size' => 40 ),
                 '$default_move_to_trash' => array( 'name' => _("By default, move to trash"),
                                                    'type' => SMOPT_TYPE_BOOLEAN ),
                 '$default_move_to_sent' => array( 'name' => _("By default, move to sent"),
                                                   'type' => SMOPT_TYPE_BOOLEAN ),
                 '$default_save_as_draft' => array( 'name' => _("By default, save as draft"),
                                                   'type' => SMOPT_TYPE_BOOLEAN ),
                 '$list_special_folders_first' => array( 'name' => _("List Special Folders First"),
                                                         'type' => SMOPT_TYPE_BOOLEAN ),
                 '$use_special_folder_color' => array( 'name' => _("Show Special Folders Color"),
                                                       'type' => SMOPT_TYPE_BOOLEAN ),
                 '$auto_expunge' => array( 'name' => _("Auto Expunge"),
                                           'type' => SMOPT_TYPE_BOOLEAN ),
                 '$default_sub_of_inbox' => array( 'name' => _("Default Sub. of INBOX"),
                                                   'type' => SMOPT_TYPE_BOOLEAN ),
                 '$show_contain_subfolders_option' => array( 'name' => _("Show 'Contain Sub.' Option"),
                                                             'type' => SMOPT_TYPE_BOOLEAN ),
                 '$default_unseen_notify' => array( 'name' => _("Default Unseen Notify"),
                                                    'type' => SMOPT_TYPE_NUMLIST,
                                                    'posvals' => array( SMPREF_UNSEEN_NONE  => _("No Notification"),
                                                                        SMPREF_UNSEEN_INBOX => _("Only INBOX"),
                                                                        SMPREF_UNSEEN_ALL   => _("All Folders")) ),
                 '$default_unseen_type'  => array( 'name' => _("Default Unseen Type"),
                                                   'type' => SMOPT_TYPE_NUMLIST ,
                                                   'posvals' => array( SMPREF_UNSEEN_ONLY  => _("Only Unseen"),
                                                                       SMPREF_UNSEEN_TOTAL => _("Unseen and Total") ) ),
                 '$auto_create_special' => array( 'name' => _("Auto Create Special Folders"),
                                                  'type' => SMOPT_TYPE_BOOLEAN ),
                 '$delete_folder' => array( 'name' => _("Auto delete folders"),
                                            'type' => SMOPT_TYPE_BOOLEAN ),
                 '$noselect_fix_enable' => array( 'name' => _("Enable /NoSelect folder fix"),
                                                  'type' => SMOPT_TYPE_BOOLEAN,
                                                  'default' => false),
                 /* --------------------------------------------------------*/
                 'Group4' => array( 'name' => _("General Options"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$data_dir' => array( 'name' => _("Data Directory"),
                                       'type' => SMOPT_TYPE_PATH,
                                       'size' => 40 ),
                 '$attachment_dir' => array( 'name' => _("Temp Directory"),
                                             'type' => SMOPT_TYPE_PATH,
                                             'size' => 40 ),
                 '$dir_hash_level' => array( 'name' => _("Hash Level"),
                                             'type' => SMOPT_TYPE_NUMLIST,
                                             'posvals' => array( 0 => _("Hash Disabled"),
                                                                 1 => _("Low"),
                                                                 2 => _("Moderate"),
                                                                 3 => _("Medium"),
                                                                 4 => _("High") ) ),
                 '$default_left_size' => array( 'name' => _("Default Left Size"),
                                                'type' => SMOPT_TYPE_NUMLIST,
                                                'posvals' => $left_size_values ),
                 '$force_username_lowercase' => array( 'name' => _("Usernames in Lowercase"),
                                                       'type' => SMOPT_TYPE_BOOLEAN ),
                 '$default_use_priority'  => array( 'name' => _("Allow use of priority"),
                                                    'type' => SMOPT_TYPE_BOOLEAN ),
                 '$hide_sm_attributions' => array( 'name' => _("Hide SM attributions"),
                                                   'type' => SMOPT_TYPE_BOOLEAN ),
                 '$default_use_mdn' => array( 'name' => _("Enable use of delivery receipts"),
                                             'type' => SMOPT_TYPE_BOOLEAN ),
                 '$edit_identity' => array( 'name' => _("Allow editing of identities"),
                                            'type' => SMOPT_TYPE_BOOLEAN ),
                 '$edit_name' => array( 'name' => _("Allow editing of full name"),
                                        'type' => SMOPT_TYPE_BOOLEAN ),
                 '$allow_server_sort' => array( 'name' => _("Use server-side sorting"),
                                                'type' => SMOPT_TYPE_BOOLEAN,
                                                'default' => false ),
                 '$allow_thread_sort' => array( 'name' => _("Use server-side thread sorting"),
                                                'type' => SMOPT_TYPE_BOOLEAN,
                                                'default' => false ),
                 '$allow_charset_search' => array( 'name' => _("Allow server charset search"),
                                                   'type' => SMOPT_TYPE_BOOLEAN,
                                                   'default' => false ),
                 '$uid_support' => array( 'name' => _("UID support"),
                                          'type' => SMOPT_TYPE_BOOLEAN,
                                          'default' => false ),
                 '$session_name' => array( 'name' => _("PHP session name"),
                                           'type' => SMOPT_TYPE_HIDDEN ),
                 /* --------------------------------------------------------*/
                 'Group5' => array( 'name' => _("Message of the Day"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$motd' => array( 'name' => _("Message of the Day"),
                                   'type' => SMOPT_TYPE_TEXTAREA,
                                   'size' => 40 ),
                 /* --------------------------------------------------------*/
                 'Group6' => array( 'name' => _("Database"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$addrbook_dsn' => array( 'name' => _("Address book DSN"),
                                           'type' => SMOPT_TYPE_STRING,
                                           'size' => 40 ),
                 '$addrbook_table' => array( 'name' => _("Address book table"),
                                             'type' => SMOPT_TYPE_STRING,
                                             'size' => 40,
                                             'default' => 'address' ),
                 '$prefs_dsn' => array( 'name' => _("Preferences DSN"),
                                        'type' => SMOPT_TYPE_STRING,
                                        'size' => 40 ),
                 '$prefs_table' => array( 'name' => _("Preferences table"),
                                          'type' => SMOPT_TYPE_STRING,
                                          'size' => 40,
                                          'default' => 'userprefs' ),
                 '$prefs_user_field' => array('name' => _("Preferences username field"),
                                              'type' => SMOPT_TYPE_STRING,
                                              'size' => 40,
                                              'default' => 'user' ),
                 '$prefs_key_field' => array('name' => _("Preferences key field"),
                                             'type' => SMOPT_TYPE_STRING,
                                             'size' => 40,
                                             'default' => 'prefkey' ),
                 '$prefs_val_field' => array('name' => _("Preferences value field"),
                                             'type' => SMOPT_TYPE_STRING,
                                             'size' => 40,
                                             'default' => 'prefval' ),
                 '$addrbook_global_dsn' => array( 'name' => _("Global address book DSN"),
                                           'type' => SMOPT_TYPE_STRING,
                                           'size' => 40 ),
                 '$addrbook_global_table' => array( 'name' => _("Global address book table"),
                                             'type' => SMOPT_TYPE_STRING,
                                             'size' => 40,
                                             'default' => 'global_abook' ),
                 '$addrbook_global_writeable' => array( 'name' => _("Allow writing into global address book"),
                                            'type' => SMOPT_TYPE_BOOLEAN ),
                 '$addrbook_global_listing' => array( 'name' => _("Allow listing of global address book"),
                                            'type' => SMOPT_TYPE_BOOLEAN ),
                 /* ---- Language settings ---- */
                 'Group9' => array( 'name' => _("Language settings"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$squirrelmail_default_language' => array( 'name' => _("Default Language"),
                                                            'type' => SMOPT_TYPE_STRLIST,
                                                            'size' => 7,
                                                            'posvals' => $language_values ),
                 '$default_charset' => array( 'name' => _("Default Charset"),
                                              'type' => SMOPT_TYPE_STRLIST,
                                              'posvals' => array( 'iso-8859-1' => 'iso-8859-1',
                                                                  'iso-8859-2' => 'iso-8859-2',
                                                                  'iso-8859-7' => 'iso-8859-7',
                                                                  'iso-8859-9' => 'iso-8859-9',
                                                                  'iso-8859-15' => 'iso-8859-15',
                                                                  'utf-8' => 'utf-8',
                                                                  'koi8-r' => 'koi8-r',
                                                                  'euc-kr' => 'euc-kr',
                                                                  'big5' => 'big5',
                                                                  'gb2312' => 'gb2312',
                                                                  'tis-620' => 'tis-620',
                                                                  'windows-1251' => 'windows-1251',
                                                                  'windows-1255' => 'windows-1255',
                                                                  'windows-1256' => 'windows-1256',
                                                                  'iso-2022-jp' => 'iso-2022-jp' ) ),
                  '$lossy_encoding'  => array( 'name' => _("Enable lossy encoding"),
                                               'type' => SMOPT_TYPE_BOOLEAN ),
                 /* ---- Settings of address books ---- */
                 'Group10' => array( 'name' => _("Address Books"),
                                     'type' => SMOPT_TYPE_TITLE ),
                 '$default_use_javascript_addr_book' => array( 'name' => _("Default Javascript Addressbook"),
                                                  'type' => SMOPT_TYPE_BOOLEAN ),
                 '$abook_global_file' => array( 'name' => _("Global address book file"),
                                                  'type' => SMOPT_TYPE_STRING ),
                 '$abook_global_file_writeable' => array( 'name' => _("Allow writing into global address book file"),
                                                  'type' => SMOPT_TYPE_BOOLEAN ),
                 /* --------------------------------------------------------*/
                 'Group7' => array( 'name' => _("Themes"),
                                    'type' => SMOPT_TYPE_TITLE ),
                 '$theme_css' => array( 'name' => _("Style Sheet URL (css)"),
                                        'type' => SMOPT_TYPE_PATH,
                                        'size' => 40 ),
                 '$theme_default' => array( 'name' => _("Default theme"),
                                            'type' => SMOPT_TYPE_INTEGER,
                                            'default' => 0,
                                            'comment' => _("Use index number of theme") ),
                 /* ---- Group8 is for plugins ---- */
                 /* --------------------------------------------------------*/
                 '$config_use_color' => array( 'name' => '',
                                               'type' => SMOPT_TYPE_HIDDEN ),
                 '$no_list_for_subscribe' => array( 'name' => '',
                                                    'type' => SMOPT_TYPE_HIDDEN ),
                 /* --------------------------------------------------------*/

               );

?>