<?php

/**
 * display_messages.php
 *
 * Copyright (c) 1999-2003 The SquirrelMail Project Team
 * Licensed under the GNU GPL. For full terms see the file COPYING.
 *
 * This contains all messages, including information, error, and just
 * about any other message you can think of.
 *
 * $Id: display_messages.php,v 1.64 2004/01/27 15:47:52 avel Exp $
 * @package squirrelmail
 */

/**
 * Find out where squirrelmail lives and try to be smart about it.
 * The only problem would be when squirrelmail lives in directories
 * called "src", "functions", or "plugins", but people who do that need
 * to be beaten with a steel pipe anyway.
 *
 * @return string the base uri of squirrelmail installation.
 */
function sqm_baseuri(){
    global $base_uri, $PHP_SELF;
    /**
     * If it is in the session, just return it.
     */
    if (isset($base_uri)){
        return $base_uri;
    }
    $dirs = array('|src/.*|', '|plugins/.*|', '|functions/.*|');
    $repl = array('', '', '');
    $base_uri = preg_replace($dirs, $repl, $PHP_SELF);
    return $base_uri;
}

function error_message($message, $mailbox, $sort, $startMessage, $color) {
    $urlMailbox = urlencode($mailbox);
    if (strtoupper($mailbox) == 'INBOX')
		    $mailbox = _("INBOX");
    $string = '<tr><td ALIGN="center">' . $message . '</td></tr>'."\n".
               '<tr><td ALIGN="center">'.
                  '<A HREF="' . sqm_baseuri() 
                  . "src/right_main.php?sort=$sort&amp;startMessage=$startMessage"
                  . "&amp;mailbox=$urlMailbox\">" .
    sprintf (_("Click here to return to %s"), imap_utf7_decode_local($mailbox)) .
	    '</A></td></tr>';
    error_box($string, $color);
}

function plain_error_message($message, $color) {
    error_box($message, $color);
}

function logout_error( $errString, $errTitle = '' ) {
    global $frame_top, $org_logo, $org_name, $org_logo_width, $org_logo_height,
           $hide_sm_attributions, $version, $squirrelmail_language;

    $base_uri = sqm_baseuri();

    include_once( SM_PATH . 'functions/page_header.php' );
    if ( !isset( $org_logo ) ) {
        // Don't know yet why, but in some accesses $org_logo is not set.
        include( SM_PATH . 'config/config.php' );
    }
    /* Display width and height like good little people */
    $width_and_height = '';
    if (isset($org_logo_width) && is_numeric($org_logo_width) && $org_logo_width>0) {
        $width_and_height = " WIDTH=\"$org_logo_width\"";
    }
    if (isset($org_logo_height) && is_numeric($org_logo_height) && $org_logo_height>0) {
        $width_and_height .= " HEIGHT=\"$org_logo_height\"";
    }

    if (!isset($frame_top) || $frame_top == '' ) {
        $frame_top = '_top';
    }

    if ( !isset( $color ) ) {
        $color = array();
        $color[0]  = '#DCDCDC';  /* light gray    TitleBar               */
        $color[1]  = '#800000';  /* red                                  */
        $color[2]  = '#CC0000';  /* light red     Warning/Error Messages */
        $color[4]  = '#FFFFFF';  /* white         Normal Background      */
        $color[7]  = '#0000CC';  /* blue          Links                  */
        $color[8]  = '#000000';  /* black         Normal text            */
    }

    if ( $errTitle == '' ) {
        $errTitle = $errString;
    }
    set_up_language($squirrelmail_language, true);

    displayHtmlHeader( $errTitle, '', false );

    echo "<BODY TEXT=\"$color[8]\" BGCOLOR=\"$color[4]\" LINK=\"$color[7]\" VLINK=\"$color[7]\" ALINK=\"$color[7]\">\n\n" .
         '<CENTER>';

    if (isset($org_logo) && ($org_logo != '')) {
        echo "<IMG SRC=\"$org_logo\" ALT=\"" . sprintf(_("%s Logo"), $org_name) .
             "\"$width_and_height><BR>\n";
    }
    echo ( $hide_sm_attributions ? '' :
           '<SMALL>' . sprintf (_("SquirrelMail version %s"), $version) . "<BR>\n".
           '  ' . _("By the SquirrelMail Development Team") . "<BR></SMALL>\n" ) .
         "<table cellspacing=1 cellpadding=0 bgcolor=\"$color[1]\" width=\"70%\"><tr><td>".
         "<TABLE WIDTH=\"100%\" BORDER=\"0\" BGCOLOR=\"$color[4]\" ALIGN=CENTER>".
            "<TR><TD BGCOLOR=\"$color[0]\" ALIGN=\"center\">".
                  "<FONT COLOR=\"$color[2]\"><B>" . _("ERROR") .
                  '</B></FONT></TD></TR>'.
            '<TR><TD ALIGN="center">' . $errString . '</TD></TR>'.
            "<TR><TD BGCOLOR=\"$color[0]\" ALIGN=\"center\">".
                  "<FONT COLOR=\"$color[2]\"><B>".
                  '<a href="' . $base_uri . 'src/login.php" target="' .
                  $frame_top . '">' .
                  _("Go to the login page") . "</a></B></FONT>".
            '</TD></TR>'.
            '</TABLE></td></tr></table></center></body></html>';
}

function error_box($string, $color) {
    global $pageheader_sent;

    $err = _("ERROR");

    /* check if the page header has been sent; if not, send it! */
    if(!isset($pageheader_sent) && !$pageheader_sent) {
        /* include this just to be sure */
        include_once( SM_PATH . 'functions/page_header.php' );
        displayHtmlHeader('SquirrelMail: '.$err);
        $pageheader_sent = TRUE;
        echo "<body text=\"$color[8]\" bgcolor=\"$color[4]\" link=\"$color[7]\" vlink=\"$color[7]\" alink=\"$color[7]\">\n\n";
    }

   echo '    <table width="100%" cellpadding="1" cellspacing="0" align="center"'.' border="0" bgcolor="'.$color[9].'">';
   echo '     <tr><td>';
   echo '       <table width="100%" cellpadding="0" cellspacing="0" align="center" border="0" bgcolor="'.$color[4].'">';
   echo '        <tr><td ALIGN="center" bgcolor="'.$color[0].'">';
   echo '           <font color="' . $color[2].'"><b>' . $err . ':</b></font>';
   echo '        </td></tr>';
   echo '        <tr><td>';
   echo '            <table cellpadding="1" cellspacing="5" align="center" border="0">';
   echo '              <tr>' . html_tag( 'td', $string."\n", 'left')
                    . '</tr>';
   echo '            </table>';
   echo '        </td></tr>';
   echo '       </table></td></tr>';
   echo '    </table>';
}
?>
