#include <stdarg.h>
#include <stdio.h>
#include <string.h>

#include "sshguard_log.h"

extern int debugging;

int sshguard_log_init(int subsystem) {
    if (! debugging) openlog("sshguard", LOG_PID, LOG_AUTH);
    return 0;
}

/* finalize the given logging subsystem */
int sshguard_log_fin(int subsystem) {
    if (! debugging) closelog();
    return 0;
}

int sshguard_log(int prio, char *fmt, ...) {
    va_list ap;
    va_start(ap, fmt);
    if (debugging) {
        vfprintf(stderr, fmt, ap);
        if (fmt[strlen(fmt)-1] != '\n') fprintf(stderr, "\n");
    } else
        vsyslog(prio, fmt, ap);
    va_end(ap);

    return 0;
}
