#ifndef SSHGUARD_PROCAUTH_H
#define SSHGUARD_PROCAUTH_H

#include <sys/types.h>

#include "sshguard_services.h"

/* initialize the procauth subsystem */
int procauth_init();

/* finalize the procauth subsystem */
int procauth_fin();

/* add a process to the list of authorizable given its configuration.
 * Configuration format is: "digit:string", meaning: service_code:pid_filename
 * service_code associates the process to a given service, see sshguard_services.h
 */
int procauth_addprocess(char *conf);

/*
 * refresh the cache of process pids by traversing their pidfiles
 * return the number of pids changed
 */
int procauth_refreshpids();

/* checks if "pid" is the authoritative process for service "service_code"
 * return:
 *    1 if authoritative
 *    -1 if NOT authoritative
 *    0 if no answer can be determined (service_code not configured or other error)
 */
int procauth_isauthoritative(int service_code, pid_t pid);


#endif

