/* @(#)dumpdate.c	1.4 03/10/14 Copyright 2003 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)dumpdate.c	1.4 03/10/14 Copyright 2003 J. Schilling";
#endif
/*
 *	Copyright (c) 2003 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <strdefs.h>
#include <errno.h>
#include <utypes.h>
#include <standard.h>
#include <schily.h>

#include "dumpdate.h"
#include "starsubs.h"

/*#define	DEBUG*/

LOCAL	dumpd_t	*dumpdates;
LOCAL	dumpd_t	**dumptail = &dumpdates;

EXPORT	void	initdumpdates	__PR((char *fname));
EXPORT	void	writedumpdates	__PR((char *fname));
LOCAL	void	outentry	__PR((FILE *f, char *name, int level,
							struct timeval *date));
EXPORT	char	*dumpdate	__PR((struct timeval *date));
LOCAL	char	*skipwht	__PR((char *p));
LOCAL	BOOL	getentry	__PR((char *line));
EXPORT	dumpd_t *checkdumpdates	__PR((const char *name, int level));
EXPORT	void	adddumpdates	__PR((const char *name, int level,
							struct timeval *date,
								BOOL useold));
LOCAL	dumpd_t *newdumpdates	__PR((const char *name, int level,
							struct timeval *date));

EXPORT void
initdumpdates(fname)
	char	*fname;
{
	FILE	*f;
	char	buf[4096];
	int	line = 0;

	f = fileopen(fname, "r");
	if (f == NULL) {
		if (geterrno() == ENOENT) {
			errmsg("Warning no %s.\n", fname);
			return;
		}
		comerr("Cannot open %s.\n", fname);
	}
	/*
	 * XXX Locking ???
	 */
	while (fgetline(f, buf, sizeof (buf)) >= 0) {
		line++;

		if (!getentry(buf)) {
			if (*skipwht(buf) != '\0') {
				errmsgno(EX_BAD,
					"Unknown format in '%s' line %d\n",
					fname, line);
			}
			continue;
		}
	}
	fclose(f);
}

EXPORT void
writedumpdates(fname)
	char	*fname;
{
	FILE	*f;
	dumpd_t	*dp;
	off_t	fsize;
	off_t	fpos;

	f = fileopen(fname, "wc");
	if (f == NULL) {
		errmsg("Cannot open '%s'.\n", fname);
		return;
	}
	fsize = filesize(f);
	for (dp = dumpdates; dp; dp = dp->next) {
		outentry(f, dp->name, dp->level, &dp->date);
	}
	fflush(f);
	fpos = filepos(f);
	while (fpos++ < fsize)
		putc(' ', f);
	fclose(f);
}

LOCAL void
outentry(f, name, level, date)
	FILE		*f;
	char		*name;
	int		level;
	struct timeval	*date;
{
	int	len;
	time_t	t = date->tv_sec; /* FreeBSD/MacOS X -> broken tv_sec/time_t */

	len = strlen(name);
	len += 7;
	len &= ~7;
	len = 41 -len;
	if (len < 1)
		len = 1;

	fprintf(f, "%s\t%*s%2d %10lld.%6.6lld %s",
		name,
		len,
		"",
		level,
		(Llong)date->tv_sec,
		(Llong)date->tv_usec,
		ctime(&t));
}

EXPORT char *
dumpdate(date)
	struct timeval	*date;
{
	char	*p;
	time_t	t = date->tv_sec; /* FreeBSD/MacOS X -> broken tv_sec/time_t */

	if (date->tv_sec == 0)
		return ("the epoch");
	p = ctime(&t);
	p[24] = '\0';
	return (p);
}

LOCAL char *
skipwht(p)
	char	*p;
{
	while (*p && (*p == ' ' || *p == '\t'))
		p++;

	return (p);
}

LOCAL BOOL
getentry(line)
	char	*line;
{
	char	*p;
	int	level;
	Llong	date;
	Llong	dfrac = 0;
	struct timeval	tdate;

	p = line;
	do {
		p = strchr(++p, '\t');
	} while (p && p[0] != '\0' && p[1] != ' ');

	if (p == NULL || p[0] == '\0')
		return (FALSE);
	*p++ = '\0';

	p = skipwht(p);
	p = astoi(p, &level);
	if (*p != ' ')
		return (FALSE);

	p = skipwht(p);
	p = astoll(p, &date);
	if (*p == '.') {
		int	l;
		char	*s = ++p;

		p = astoll(s, &dfrac);
		l = p - s;
		if (l > 9) {		/* Number too big, limit to nsec */
			char	*p2 = p;

			l = s[9];
			s[9] = '\0';
			p = astoll(s, &dfrac);
			s[9] = l;
			l = p - s;
			p = p2;
		}
		while (l < 6) {		/* Convert to usecs */
			dfrac  *= 10;
			l++;
		}
		while (l > 6) {		/* Convert to usecs */
			dfrac  /= 10;
			l--;
		}
	}
	if (*p != ' ')
		return (FALSE);

	tdate.tv_sec = date;
	tdate.tv_usec = dfrac;
	adddumpdates(line, level, &tdate, FALSE);

	return (TRUE);
}

EXPORT dumpd_t *
checkdumpdates(name, level)
	const char	*name;
	int		level;
{
	dumpd_t	*dp = dumpdates;
	dumpd_t	*rp = NULL;

	for (; dp; dp = dp->next) {
		if (!streql(name, dp->name))
			continue;
		if (level <= dp->level)
			continue;
		rp = dp;
	}
#ifdef	DEBUG
	if (rp)
		outentry(stderr, rp->name, rp->level, &rp->date);
#endif
	return (rp);
}

EXPORT void
adddumpdates(name, level, date, useold)
	const char	*name;
	int		level;
	struct timeval	*date;
	BOOL		useold;
{
	dumpd_t	*dp = dumpdates;

	for (; dp; dp = dp->next) {
		if (streql(name, dp->name) && level == dp->level) {
			if (useold) {
				dp->date = *date;
				return;
			}
			errmsgno(EX_BAD,
				"Duplicate tardumps entry '%s %d %lld'.\n",
				dp->name, dp->level, (Llong)dp->date.tv_sec);

			if (date->tv_sec == dp->date.tv_sec)
				return;
			comerrno(EX_BAD, "Timestamps differs - aborting.\n");
		}
	}
	dp = newdumpdates(name, level, date);
	*dumptail = dp;
	dumptail = &dp->next;
}

LOCAL dumpd_t *
newdumpdates(name, level, date)
	const char	*name;
	int		level;
	struct timeval	*date;
{
	dumpd_t	*dp;

	dp	  = __malloc(sizeof (*dp), "tardumps entry");
	dp->next  = NULL;
	dp->name  = __savestr(name);
	dp->level = level;
	dp->date  = *date;

	return (dp);
}
