/* @(#)restore.c	1.2 04/03/01 Copyright 2003-2003 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)restore.c	1.2 04/03/01 Copyright 2003-2004 J. Schilling";
#endif
/*
 *	Data base management for incremental restores
 *	needed to detect and execute rename() and unlink()
 *	operations between two incremental dumps.
 *
 *	Copyright (c) 2003-2004 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <mconfig.h>
#include <stdio.h>
#include <stdxlib.h>
#include <unixstd.h>
#include <standard.h>
#include "star.h"
#include "props.h"
#include "table.h"
#include "diff.h"
#include <strdefs.h>
#include <schily.h>
#include <dirdefs.h>	/* XXX Wegen S_IFLNK */
#include "starsubs.h"
#include "checkerr.h"

extern	BOOL	debug;
extern	int	verbose;

/*
 * Inode mapping from archive and /star-symtable
 */
typedef struct imap imap_t;
struct imap {
	imap_t	*i_next;	/* Next in list			*/
	char	*i_name;	/* File name			*/
	ino_t	i_oino;		/* Old inode number		*/
	ino_t	i_nino;		/* New inode number		*/
	Int32_t	i_flags;	/* Flags (see below)		*/
};

/*
 * Flags for i_flags:
 */
#define	I_DIR		0x01	/* This is a directory		*/
#define	I_NOARCHIVE	0x02	/* Name in archive, file is not	*/

#define	NO_INO	(ino_t)-1

LOCAL	imap_t	*imaps = NULL;
#ifdef	DEBUG
LOCAL	int	nimp;
#endif

LOCAL	imap_t	*nfind_node	__PR((char *name));
#ifdef	__needed__
LOCAL	imap_t	*oifind_node	__PR((ino_t oino));
LOCAL	imap_t	*nifind_node	__PR((ino_t nino));
#endif
#ifdef	__needed__
LOCAL	imap_t	*find_node	__PR((char *name, ino_t oino, ino_t nino));
#endif
LOCAL	imap_t	*add_node	__PR((char *name, ino_t oino, ino_t nino, Int32_t flags));
EXPORT	void	sym_addrec	__PR((FINFO *info));
EXPORT	void	sym_addstat	__PR((FINFO *info));
EXPORT	void	sym_preremove	__PR((FINFO *info));
EXPORT	void	sym_open	__PR((void));
LOCAL	int	ngetline	__PR((FILE *f, char *buf, int len));
EXPORT	void	sym_close	__PR((void));
LOCAL	void	printonesym	__PR((FILE *f, imap_t *imp));
LOCAL	void	printsym	__PR((FILE *f));
LOCAL	BOOL	dirdiskonly	__PR((FINFO *info, int *odep, char ***odp));

LOCAL imap_t *
nfind_node(name)
	char	*name;
{
	register imap_t	*imp = imaps;
	register char	*np;
	register char	*inp;

	while (imp) {
		np = name;
		inp = imp->i_name;
		while (*inp) {
			if (*np++ != *inp++)
				goto nextmatch;
		}
		if (np[0] == '\0')
			break;
		if (np[0] == '/' && np[1] == '\0')
			break;
nextmatch:
		imp = imp->i_next;
	}
	return (imp);
}

#ifdef	__needed__
LOCAL imap_t *
oifind_node(oino)
	ino_t	oino;
{
	register imap_t	*imp = imaps;

	while (imp) {
		if (oino == imp->i_oino)
			break;
		imp = imp->i_next;
	}
	return (imp);
}

LOCAL imap_t *
nifind_node(nino)
	ino_t	nino;
{
	register imap_t	*imp = imaps;

	while (imp) {
		if (nino == imp->i_nino)
			break;
		imp = imp->i_next;
	}
	return (imp);
}
#endif

#ifdef	__needed__
LOCAL imap_t *
find_node(name, oino, nino)
	char	*name;
	ino_t	oino;
	ino_t	nino;
{
	register imap_t	*imp = imaps;

	while (imp) {
		if (oino != NO_INO && oino == imp->i_oino)
			break;
		if (nino != NO_INO && nino == imp->i_nino)
			break;
		if (name != NULL && streql(name, imp->i_name))
			break;
		imp = imp->i_next;
	}
	return (imp);
}
#endif

LOCAL imap_t *
add_node(name, oino, nino, flags)
	char	*name;
	ino_t	oino;
	ino_t	nino;
	Int32_t	flags;
{
	register imap_t	*imp;

	imp = __malloc(sizeof (imap_t), "new imap");
	imp->i_name = __savestr(name);
	imp->i_oino = oino;
	imp->i_nino = nino;
	imp->i_flags = flags;
	imp->i_next = imaps;
	imaps = imp;
#ifdef	DEBUG
	nimp++;
#endif
	return (imp);
}

EXPORT void
sym_addrec(info)
	FINFO	*info;
{
	imap_t	*imp;
	BOOL	isold = TRUE;

	if ((imp = nfind_node(info->f_name)) == NULL) {
		isold = FALSE;
		imp = add_node(info->f_name, info->f_ino, (ino_t)0, 0);
	}
/*else error ("found %s\n", info->f_name);*/
	if (is_dir(info)) {
		int	len = strlen(imp->i_name);

		if (imp->i_name[len-1] == '/')
			imp->i_name[len-1] = '\0';
		imp->i_flags |= I_DIR;
	}
/*	printonesym(stderr, imp);*/

	if (is_dir(info)) {
		char	buf[2*PATH_MAX+1];
		char	*p;
		char	*dp;
		ino_t	*ip;
		int	dlen;
		int	len;
		int	i;

		strcpy(buf, imp->i_name);
		dlen = strlen(buf);
		p = &buf[dlen];
		*p++ = '/';
		dp = info->f_dir;
		ip = info->f_dirinos;
		if (dp == NULL || ip == NULL)
			return;

		i = 0;
		while (*dp) {
			dp++;
			len = strlen(dp);
			strcpy(p, dp);

			if ((imp = nfind_node(buf)) == NULL) {
				imp = add_node(buf, (ino_t)0, (ino_t)0, 0);
			}
			if (imp->i_oino == (ino_t)0)
				imp->i_oino = ip[i];
/*			printonesym(stderr, imp);*/
			i++;
			dp += len+1;
		}
	}
}

EXPORT void
sym_addstat(info)
	FINFO	*info;
{
	FINFO	finfo;
	imap_t	*imp;
	BOOL	isold = TRUE;

	if ((imp = nfind_node(info->f_name)) == NULL) {
/*error("NOT found %s\n", info->f_name);*/
		isold = FALSE;
		imp = add_node(info->f_name, info->f_ino, (ino_t)0, 0);
	}

	fillbytes((char *)&finfo, sizeof (finfo), '\0');
	_getinfo(info->f_name, &finfo);
	imp->i_nino = finfo.f_ino;
	if (is_dir(info)) {
		int	len = strlen(imp->i_name);

		if (imp->i_name[len-1] == '/')
			imp->i_name[len-1] = '\0';
		imp->i_flags |= I_DIR;
	}
/*	printonesym(stderr, imp);*/
}

EXPORT void
sym_preremove(info)
	FINFO	*info;
{
	char	**od;
	int	dlen;
	int	i;

if (1)
	return;
	dirdiskonly(info, &dlen, &od);

	for (i = 0; i < dlen; i++) {
		error("Only on disk '%s': '%s'\n",
				info->f_name, od[i] + 1);
	}
}

EXPORT void
sym_open()
{
		char	buf[2*PATH_MAX+1];
/*		char	buf[8192];*/
		FILE	*f = fileopen("star-symtable", "r");
		int	amt;
		char	*p;
		Llong	ll;
		ino_t	oino;
		ino_t	nino;

	if (f == NULL) {
		errmsg("Cannot open 'star-symtable'.\n");
		return;
	}
	while ((amt = ngetline(f, buf, sizeof (buf))) > 0) {
		if (getc(f) != '\n')
			comerrno(EX_BAD, "Missing newline at end of record.\n");
		p = buf;

		p++;	/* Skip Flag */
		p = astollb(p, &ll, 10);
		if (*p != '\t')
			comerrno(EX_BAD, "Missing TAB after old ino.\n");
		oino = ll;
		p = astollb(p, &ll, 10);
		if (*p != '\t')
			comerrno(EX_BAD, "Missing TAB after NEW ino.\n");
		nino = ll;
		add_node(++p, oino, nino, 0);
	}
	fclose(f);
printsym(stderr);
}

/*
 * A special version of fgetline() that does not stop on '\n' but only on '\0'.
 */
LOCAL int
ngetline(f, buf, len)
	register	FILE	*f;
			char	*buf;
	register	int	len;
{
	register int	c	= '\0';
	register char	*bp	= buf;
	register int	nul	= '\0';

	for (;;) {
		if ((c = getc(f)) < 0)
			break;
		if (c == nul)
			break;
		if (--len > 0) {
			*bp++ = c;
		} else {
			/*
			 * Read up to end of line
			 */
			while ((c = getc(f)) >= 0 && c != nul)
				;
			break;
		}
	}
	*bp = '\0';
	/*
	 * If buffer is empty and we hit EOF, return EOF
	 */
	if (c < 0 && bp == buf)
		return (c);

	return (bp - buf);
}



EXPORT void
sym_close()
{
	FILE	*f = fileopen("star-symtable", "wct");

	if (f == NULL) {
		errmsg("Cannot create 'star-symtable'.\n");
		return;
	}
	printsym(f);
	fclose(f);
}

LOCAL void
printonesym(f, imp)
		FILE	*f;
	register imap_t	*imp;
{
	fprintf(f, "%c %lld	%lld	%s%c\n",
			imp->i_flags & I_DIR ? 'D':' ',
			(Llong)imp->i_oino, (Llong)imp->i_nino,
			imp->i_name,
			0);
}

LOCAL void
printsym(f)
	FILE	*f;
{
	register imap_t	*imp = imaps;

#ifdef	DEBUG
	error("nimp %d\n", nimp);
#endif
	while (imp) {
		printonesym(f, imp);
		imp = imp->i_next;
	}
}

/*EXPORT BOOL*/
LOCAL BOOL
dirdiskonly(info, odep, odp)
	FINFO	*info;
	int	*odep;
	char	***odp;
{
	register char	**ep1;	   /* Directory entry pointer array (arch) */
	register char	**ep2 = 0; /* Directory entry pointer array (disk) */
	register char	*dp2;	   /* Directory names string from disk	   */
	register char	**oa = 0;  /* Only in arch pointer array	   */
	register char	**od = 0;  /* Only on disk pointer array	   */
	register int	i;
		int	ents1 = -1;
		int	ents2;
		int	dlen = 0;  /* # of entries only on disk		*/
		int	alen = 0;  /* # of entries only in arch		*/
		BOOL	diffs = FALSE;

	/*
	 * Old archives had only one nul at the end
	 * xheader.c already increments info->f_dirlen in this case
	 * but a newline may appear to be the last char.
	 * Note that we receicve the space from the xheader
	 * extract buffer.
	 */
	i = info->f_dirlen;
	if (info->f_dir[i-1] != '\0')
		info->f_dir[i-1] = '\0';	/* Kill '\n' */

	ep1 = sortdir(info->f_dir, &ents1);	/* from archive */
	dp2 = fetchdir(info->f_name, &ents2, 0, (ino_t **)0);
	if (dp2 == NULL) {
		diffs = TRUE;
		errmsg("Cannot read dir '%s'.\n", info->f_name);
		goto no_dircmp;
	}
	ep2 = sortdir(dp2, &ents2);		/* from disk */

	if (ents1 != ents2) {
		if (debug || verbose > 2) {
			error("Archive ents: %d Disk ents: %d '%s'\n",
					ents1, ents2, info->f_name);
		}
		diffs = TRUE;
	}

	if (cmpdir(ents1, ents2, ep1, ep2, NULL, NULL, &alen, &dlen) > 0)
		diffs = TRUE;

	oa = __malloc(alen * sizeof (char *), "dir diff array");
	od = __malloc(dlen * sizeof (char *), "dir diff array");
	cmpdir(ents1, ents2, ep1, ep2, oa, od, &alen, &dlen);

#ifdef	DEBUG
	for (i = 0; i < dlen; i++) {
		error("Only on disk '%s': '%s'\n",
				info->f_name, od[i] + 1);
	}
	for (i = 0; i < alen; i++) {
		error("Only in archive '%s': '%s'\n",
				info->f_name, oa[i] + 1);
	}
#endif

no_dircmp:
	if (odep)
		*odep = dlen;

	if (dp2)
		free(dp2);
	if (ep1)
		free(ep1);
	if (ep2)
		free(ep2);
	if (odp)
		*odp = od;
	else if (od)
		free(od);
	if (oa)
		free(oa);

	return (diffs);
}
