/* @(#)suntar.c	1.7 04/03/07 Copyright 2003 J. Schilling */
#ifndef lint
static	char _sccsid[] =
	"@(#)suntar.c	1.7 04/03/07 Copyright 2003 J. Schilling";
#endif
/*
 *	Solaris TAR specific routines for star main program.
 *
 *	Copyright (c) 1989, 2003 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; see the file COPYING.  If not, write to the Free Software
 * Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef	STAR_MAIN
/*
 * We have been included from star.c
 * XXX If we like a 'fat' binary to read "/etc/default/tar", we need to
 * XXX hack new code!
 */
#else
#define	NO_STAR_MAIN
#define	SUN_TAR
#define	DFLT_FILE	"/etc/default/tar"

#include "star.c"
#endif

/*
 * tar {crtux}[bBeEfFhiklmnopPqvwX@[0-7]] [-k size] [blocksize] [tapefile] [exclude-file] [-I include-file] files ...
 *
 *	-I fehlt noch
 */


/*
 * Solaris TAR related options
 */
char	_opts[] = "C*,help,xhelp,version,debug,xdebug#,xd#,time,no-statistics,fifostats,numeric,no-fifo,no-fsync,bs&,fs&,/,..,secure-links,acl,xfflags,copy,diff,O,z,bz,c,r,t,u,x,b&,B,e,E,f&,F,h,i,k&,l,m,n,o,p,P,q,v+,w,X*,@,?";
char	*opts = _opts;

LOCAL	void	suntar_info	__PR((void));

LOCAL void
gargs(ac, av)
	int		ac;
	char	*const *av;
{
	int	files	 = 0;
	int	minfiles = 1;
	BOOL	help	 = FALSE;
	BOOL	xhelp	 = FALSE;
	BOOL	prvers	 = FALSE;
	BOOL	no_fifo	 = FALSE;
	BOOL	oldtar   = FALSE;
	BOOL	suneflag = FALSE;	/* Spter */
	BOOL	sunEflag = FALSE;
	BOOL	sunpflag = FALSE;
	BOOL	sunqflag = FALSE;
	char	*sunX    = NULL;
	BOOL	sunxattr = FALSE;
	char	archive  = -1;

	/*
	 * Current default archive format in all other cases is USTAR.
	 * We may change this to PAX in the future.
	 */
	hdrtype = H_USTAR;

	iftype		= I_TAR;		/* command line interface */
	bsdchdir	= TRUE;

	--ac, ++av;
	files = getfilecount(ac, av, opts);
	if (getallargs(&ac, &av, opts,
				&dir_flags,
				&help, &xhelp, &prvers, &debug, &xdebug, &xdebug,
#ifndef	lint
				&showtime, &no_stats, &do_fifostats,
				&numeric,  &no_fifo, &no_fsync,
				getnum, &bs,
				getnum, &fs,
				&abs_path, &allow_dotdot, &secure_links,
				&doacl, &dofflags,
				&copyflag, &diff_flag,
				&oldtar,
				&zflag, &bzflag,

				&cflag,
				&rflag,
				&tflag,
				&uflag,
				&xflag,

				getnum, &bs,		/* -b blocks */
				&multblk,		/* -B */
				&suneflag,		/* -e */
				&sunEflag,		/* -E */
				addtarfile, NULL,	/* -f archive */
				&Fflag,			/* -F */
				&paxfollow,		/* -h */
				&ignoreerr,		/* -i */
				getknum, &tsize,	/* -k size */
				&nolinkerr,		/* -l */
				&nomtime,		/* -m */
				&not_tape,		/* -n */
				&nochown,		/* -o */
				&sunpflag,		/* -p */
				&no_dirslash,		/* -P */
				&sunqflag,		/* -q */
				&verbose,		/* -v */
				&interactive,		/* -w */
				&sunX,			/* -X */
				&sunxattr,		/* -@ */
#endif /* lint */
				&archive) < 0) {
		errmsgno(EX_BAD, "Bad Option: %s.\n", av[0]);
		susage(EX_BAD);
	}
	if (archive != -1 && !(archive >= '0' && archive <= '7')) {
		errmsgno(EX_BAD, "Bad Option: -%c.\n", archive);
		susage(EX_BAD);
	}
	star_helpvers("suntar", help, xhelp, prvers);

	if (suneflag) {
		errmsgno(EX_BAD, "The -e option is not yet implemented.\n");
		susage(EX_BAD);
	}
	if (sunEflag) {
		errmsgno(EX_BAD, "The -E option is not yet implemented.\n");
		susage(EX_BAD);
	}
	if (not_tape) {
		errmsgno(EX_BAD, "The -n option is not yet implemented.\n");
		susage(EX_BAD);
	}
	if (sunpflag) {
		pflag = TRUE;
		doacl = TRUE;
	}
	if (sunqflag) {
		errmsgno(EX_BAD, "The -q option is not yet implemented.\n");
		susage(EX_BAD);
	}
	if (sunX) {
		errmsgno(EX_BAD, "The -X option is not yet implemented.\n");
		susage(EX_BAD);
	}
	if (sunxattr) {
		errmsgno(EX_BAD, "The -@ option is not yet implemented.\n");
		susage(EX_BAD);
	}

	star_checkopts(oldtar, /* dodesc */ FALSE, /* usetape */ TRUE,
					archive, no_fifo, /* llbs */ 0);
	star_nfiles(files, minfiles);

	star_defaults(&fs, DFLT_FILE);	/* Also check for Sun defaults */
}

LOCAL void
suntar_info()
{
	error("\nFor a more complete user interface use the tar type command interface.\n");
	error("See 'man star'. The %s command is more or less limited to the\n", get_progname());
	error("Solaris tar command line interface.\n");
}

/*
 * Short usage
 */
LOCAL void
susage(ret)
	int	ret;
{
	error("Usage:\t%s cmd [options] file1 ... filen\n", get_progname());
	error("\nUse\t%s --help\n", get_progname());
	error("and\t%s --xhelp\n", get_progname());
	error("to get a list of valid cmds and options.\n");
/*	error("\nUse\t%s -x help\n", get_progname());*/
/*	error("to get a list of valid archive header formats.\n");*/
	suntar_info();
	exit(ret);
	/* NOTREACHED */
}

LOCAL void
usage(ret)
	int	ret;
{
	error("Usage:\t%s cmd [options] file1 ... filen\n", get_progname());
	error("Cmd:\n");
	error("\t-c/-u/-r\tcreate/update/replace archive with named files to tape\n");
	error("\t-x/-t\t\textract/list named files from tape\n");
	error("\t--copy\t\t(*) copy named files to destination directory\n");
	error("\t--diff\t\t(*) diff archive against file system (see -xhelp)\n");
	error("Options:\n");
	error("\t--help\t\t(*) print this help\n");
	error("\t--xhelp\t\t(*) print extended help\n");
	error("\t--version\t(*) print version information and exit\n");
	error("\t-b #\t\tset blocking factor to #x512 Bytes (default 20)\n");
	error("\t-B\t\tperform multiple reads (needed on pipes)\n");
	error("\t-e\t\tXXX Not implemented\n");
	error("\t-E\t\tXXX Not implemented\n");
	error("\t-f nm\t\tuse 'nm' as tape instead of stdin/stdout\n");
	error("\t-F,-FF,-FFF,...\tdo not store/create SCCS/RCS, core and object files\n");
	error("\t-h\t\tfollow symbolic links as if they were files\n");
	error("\t-i\t\tignore checksum errors\n");
	error("\t-k yy\t\tXXX Not implemented\n");
	error("\t-l\t\tprint a message if not all links are dumped\n");
	error("\t-m\t\tdo not restore access and modification time\n");
	error("\t-n\t\tXXX Not implemented\n");
	error("\t-o\t\tdo not restore owner and group\n");
	error("\t-O\t\t(*)be compatible to old tar (except for checksum bug)\n");
	error("\t-p\t\trestore filemodes of directories\n");
	error("\t-P\t\tXXX Not implemented\n");
	error("\t-q\t\tXXX Not implemented\n");
	error("\t-v\t\tincrement verbose level\n");
	error("\t-w\t\tdo interactive creation/extraction/renaming\n");
	error("\t-X yy\t\tXXX Not implemented\n");
	error("\t-@\t\tXXX Not implemented\n");
	error("\t-[0-7]\t\tSelect an alternative tape drive\n");
	error("\t-z\t\t(*) pipe input/output through gzip, does not work on tapes\n");
	error("\t--bz\t\t(*) pipe input/output through bzip2, does not work on tapes\n");
#ifdef	FIFO
	error("\t--no-fifo\t(*) don't use a fifo to optimize data flow from/to tape\n");
#endif
	error("\nAll options marked with (*) are not defined by Solaris tar.\n");
	suntar_info();
	exit(ret);
	/* NOTREACHED */
}

LOCAL void
xusage(ret)
	int	ret;
{
	error("Usage:\t%s cmd [options] file1 ... filen\n", get_progname());
	error("Extended options:\n");
	error("\t--debug\t\tprint additional debug messages\n");
	error("\txdebug=#,xd=#\tset extended debug level\n");
	error("\t-/\t\tdon't strip leading '/'s from file names\n");
	error("\t-..\t\tdon't skip filenames that contain '..' in non-interactive extract\n");
	error("\t--secure-links\tdon't extract links that start with '/' or contain '..'\n");
	error("\t--acl\t\thandle access control lists\n");
	error("\t--xfflags\thandle extended file flags\n");
	error("\tbs=#\t\tset (output) block size to #\n");
#ifdef	FIFO
	error("\tfs=#\t\tset fifo size to #\n");
#endif
	error("\t--no-fsync\tdo not call fsync() for each extracted file (may be dangerous)\n");
	error("\t--time\t\tprint timing info\n");
	error("\t--no-statistics\tdo not print statistics\n");
#ifdef	FIFO
	error("\t--fifostats\tprint fifo statistics\n");
#endif
	error("\t--numeric\tdon't use user/group name from tape\n");
	error("\nAll options above are not defined by Solaris tar.\n");
	exit(ret);
	/* NOTREACHED */
}
