#ifndef __SD_CONF_H__
#define __SD_CONF_H__

#include <libgnome/libgnome.h>
#include <gconf/gconf-client.h>

class AppConf
{
private:
	GConfClient *gconf_client;

	static void dictionary_scan_selection_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void dictionary_only_scan_while_modifier_key_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void dictionary_hide_floatwin_when_modifier_key_released_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void dictionary_scan_modifier_key_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void dictionary_enable_sound_event_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void main_window_searchwebsite_list_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void main_window_hide_list_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);	
	static void notification_area_icon_show_in_floatwin_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_pronounce_when_popup_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_max_window_width_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_max_window_height_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_lock_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_lock_x_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
	static void floatwin_lock_y_changed_cb(GConfClient *client, guint id, GConfEntry *entry, gpointer data);
public:
	AppConf();
	~AppConf();

	void EnableNotify();
	void DisableNotify();

	void read_bool(const gchar *key, gboolean *val, gboolean def);
	void write_bool(const gchar *key, gboolean val);
	void read_int(const gchar *key, gint *val ,gint def);	
	void write_int(const gchar *key, gint val);
	void read_string(const gchar *key, gchar **str);
	void write_string(const gchar *key, const gchar *str);
	void read_list(const gchar *key, GConfValueType list_type, GSList **list);
	void write_list(const gchar *key, GConfValueType list_type, GSList *list);
};

#endif
