#ifndef __STAR_DICT_H__
#define __STAR_DICT_H__

#include <gtk/gtk.h>

#if !defined(_WIN32) && !defined(WITHOUT_GNOME)
# include <bonobo/bonobo-object.h>
# include <libgnome/libgnome.h>
#endif


class AppCore;
class AppFrame;

#include "skin.h"
#include "lib.h"
#include "mainwin.h"
#ifdef _WIN32
#  include "win32/clipboard.h"	
#  include "win32/systray.h"
#else
#  include "docklet.h"
#endif
#include "floatwin.h"
#include "selection.h"
#include "prefsdlg.h"
#include "dictmanagedlg.h"
#include "readword.h"

extern AppFrame * gpAppFrame;

//notice!!! when you change these DEFAULT const value,remember that you'd better change data/stardict.schemas.in too!

const int MAX_FUZZY_MATCH_ITEM=100;
const int MAX_FLOAT_WINDOW_FUZZY_MATCH_ITEM=5;

const int LIST_WIN_ROW_NUM = 30; //how many words show in the list win.


class AppCore
{
private:
	AppFrame* poAppFrame;

	PrefsDlg *prefs_dlg;
	DictManageDlg *dict_manage_dlg;

	static int MatchWordCompare(const void * s1, const void * s2);
	static gboolean on_delete_event(GtkWidget * window, GdkEvent *event , AppCore *oAppCore);
	static gboolean on_window_state_event(GtkWidget * window, GdkEventWindowState *event , AppCore *oAppCore);
	static gboolean on_window_visibility_notify(GtkWidget * window, GdkEventVisibility *event , AppCore *oAppCore);
	static gboolean vKeyPressReleaseCallback(GtkWidget * window, GdkEventKey *event , AppCore *oAppCore);
public:
	glong *iCurrentIndex;
	GtkWidget *window;
	GtkTooltips *tooltips;

	TopWin oTopWin;
	MidWin oMidWin;
	BottomWin oBottomWin;

	Selection oSelection;
#ifdef _WIN32
	Clipboard oClipboard;
#endif
	FloatWin oFloatWin;
	DockLet oDockLet;

	Libs oLibs;
	TreeDicts oTreeDicts;

	AppCore(AppFrame* pAppFrame);
	~AppCore();
	void Create(gchar *queryword);
    void End();
	void Query(const gchar *word);
	bool SimpleLookupToFloat(const gchar* sWord, bool bShowIfNotFound);
	bool SimpleLookupToTextWin(const gchar* sWord,glong* piIndex, bool piIndexValid = false, bool bTryMoreIfNotFound = false);
	void LookupWithFuzzyToMainWin(const gchar* word);
	void LookupWithFuzzyToFloatWin(const gchar * word);
	void LookupWithRuleToMainWin(const gchar* word);
	void ShowDataToTextWin(gchar ** ppWord, gchar ** ppWordData,const gchar * sOriginWord);
	void ShowTreeDictDataToTextWin(glong offset, glong size, gint iTreeDict);
	void ShowNotFoundToTextWin(const char* sWord,const char* sReason, TextWinQueryResult query_result);	
	void ShowDataToFloatWin(gchar ** ppWord, gchar ** ppWordData,const gchar * sOriginWord);
	void ShowDatasToFloatWin(gchar *** pppWord, gchar *** pppWordData, const gchar ** ppOriginWord, gint count, const gchar * sOriginWord);
	void ShowNotFoundToFloatWin(const char* sWord,const char* sReason, gboolean fuzzy);

	void TopWinEnterWord(const gchar *text);
	void TopWinWordChange(const gchar* sWord);
	void ListWords(glong * iStartIndex);
	
	void ListClick(const gchar *word);
	void PopupPrefsDlg();
	void PopupDictManageDlg();
};

class AppFrame {
public:
	AppCore oAppCore;
	AppSkin oAppSkin;
	ReadWord oReadWord;


#if !defined(_WIN32) && !defined(WITHOUT_GNOME)
	BonoboObject *stardict_app_server;
#endif

	AppFrame();
	~AppFrame();
	void Init(gchar *queryword);
	void Quit();
};

#ifdef _WIN32
extern HINSTANCE stardictexe_hInstance;
#endif

extern gboolean bContainRule(const char* sWord);
extern gchar* GetPureEnglishAlpha(gchar *str);
extern gchar* GetHeadWord(gchar *str);
extern gboolean stardict_on_enter_notify (GtkWidget * widget, GdkEventCrossing * event, gpointer data);

#endif
