/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#include <stdio.h>
#include <stdlib.h>
#include <glib.h>
#include "catinfo.h"

struct catinfo *getcatinfo(char *filebase)
{
	char filename[1000], line[1000];
	FILE *in;
	int n, i, start = 0, stop = 0;
	struct catinfo *info = 0;

	sprintf(filename, "%s/share/stars/data/%s.def", PREFIXDIR, filebase);
	in = fopen(filename, "r");
	if(!in)
	{
/* This feature not yet supported */
//		fprintf(stderr, "getcatinfo : Warning -- no .def file for %s\n", filebase);
//		fprintf(stderr, "getcatinfo :            looking for %s\n", filename);
		return 0;
	}

	fgets(line, 999, in);
	if(feof(in))
	{
		fprintf(stderr, "getcatinfo : Warning -- bad file\n");
		return 0;
	}
	info = g_new(struct catinfo, 1);
	for(i = 0; i < 999; i++) if(line[i] < ' ') break;
	line[i] = 0;
	info->rawfile = g_strdup(line);
	fgets(line, 999, in);
	for(i = 0; i < 999; i++) if(line[i] < ' ') break;
	line[i] = 0;
	sscanf(line, "%d%d", &info->num, &info->reclen);
	info->items = g_new(struct catinfoitem, info->num);
	for(n = 0; n < info->num; n++)
	{
		fgets(line, 999, in);
		for(i = 0; i < 999; i++) if(line[i] < ' ') break;
		for(; i >= 0; i--) if(line[i] == '\"') break;
		if(i < 0)
		{
			fprintf(stderr, "getcatinfo : Warning -- parse error.  memory leaked\n");
			fprintf(stderr, "getcatinfo :   %s.def : %s\n", filebase, line);
			return 0;
		}
		line[i] = 0;
		if(sscanf(line, "%d%d", &start, &stop) < 2 || start > stop)
		{
			fprintf(stderr, "getcatinfo : Warning -- parse error.  memory leaked\n");
                        fprintf(stderr, "getcatinfo :   %s.def : %s\n", filebase, line);
                        return 0;
		}
		for(i = 0; line[i] > 0; i++) if(line[i] == '\"') break;
		if(line[i] == 0) 
		{
			fprintf(stderr, "getcatinfo : Warning -- parse error.  memory leaked\n");
			return 0;
		}
		i++;
		info->items[n].startcol = start;
		info->items[n].stopcol = stop;
		info->items[n].name = g_strdup(line+i);
	}

	return info;
}

void printcatinfo(struct catinfo *info, int num)
{
	FILE *in;
	char line[1000], tmp[100];
	gchar *fullfilename;
	int i, j, k;

	fullfilename = g_strconcat(PREFIXDIR, "/share/stars/data/", info->rawfile, 0);
	in = fopen(info->rawfile, "r");
	if(!in)
	{
		fprintf(stderr, "Can't load raw data : %s\n", fullfilename);
		g_free(fullfilename);
		return;
	}
	g_free(fullfilename);

	if(num > 0)
	{
		if(info->reclen > 0) fseek(in, num*info->reclen, SEEK_SET);
		else for(i = 0; i < num; i++) fgets(line, 999, in);
	}
	fgets(line, 999, in);
	printf("line = %s\n", line);
	for(i = 0; i < info->num; i++)
	{
		k = 0;
		for(j = info->items[i].startcol; j <= info->items[i].stopcol; j++) tmp[k++] = line[j];
		tmp[k] = 0;
		printf("%15s : %s\n", info->items[i].name, tmp);
	}
	fclose(in);
}

void destroycatinfo(struct catinfo *info)
{
	int i;

	if(info == 0) 
	{
		fprintf(stderr, "Warning : destroying null catinfo\n");
		return;
	}
	for(i = 0; i < info->num; i++) g_free(info->items[i].name);
	g_free(info->rawfile);
	g_free(info->items);
	g_free(info);
}

