/* Stars -- Displays a Map of the Night Sky
    Copyright (C) September 22, 2002  Walter Brisken

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA*/

#ifndef __CONFIGURELOCATION_H__
#define __CONFIGURELOCATION_H__

#include "configure.h"
#include "glade/glade.h"
#include "location.h"

struct locationconfig
{
	GtkWidget *citybutton;
	GtkWidget *citycombo;
	GtkWidget *cityentry;
	GtkWidget *citylist;
	GtkWidget *citylabel;
	GtkWidget *obsbutton;
	GtkWidget *obscombo;
	GtkWidget *obsentry;
	GtkWidget *obslist;
	GtkWidget *obslabel;
	GtkWidget *otherbutton;
	GtkWidget *latentry;
	GtkWidget *NScombo;
	GtkWidget *NSentry;
	GtkWidget *NSlist;
	GtkWidget *longentry;
	GtkWidget *WEcombo;
	GtkWidget *WEentry;
	GtkWidget *WElist;
	GtkWidget *eleventry;
	GtkWidget *elevunitscombo;
	GtkWidget *elevunitsentry;
	GtkWidget *elevunitslist;
	GtkWidget *addcitybutton;
	GtkWidget *addobsbutton;

	struct location *oldloc, *curloc;
};

struct locationconfig *newlocationconfig(GladeXML *configxml);
void deletelocationconfig(struct locationconfig *lc);
void locationconfigupdate(struct locationconfig *lc);
void locationconfigsetup(struct configurator *cfg);
void locationconfigtry(struct configurator *cfg);
void locationconfigrevert(struct configurator *cfg);

#endif
