package net.sf.statcvs.pages;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

import net.sf.statcvs.Main;
import net.sf.statcvs.model.Directory;
import net.sf.statcvs.output.ChurnPageMaker;
import net.sf.statcvs.output.RepoMapPageMaker;
import net.sf.statcvs.output.ReportConfig;
import net.sf.statcvs.pages.xml.GenerateXml;

/**
 * TODO: Clean up
 * 
 * @author Anja Jentzsch
 * @author Benoit Xhenseval (OutputRenderer and ExtraReportRegister interfaces)
 * @version $Id: ReportSuiteMaker.java,v 1.8 2009/05/01 13:42:46 benoitx Exp $
 */
public class ReportSuiteMaker {

    /**
     * Path to web distribution files inside the distribution JAR, relative to
     * the {@link net.sf.statcvs.Main} class
     */
    public static final String WEB_FILE_PATH = "web-files/";

    public static final String DIRECTORY_ICON = "folder.png";
    public static final String BUG_ICON = "bug.png";
    public static final String TWEET_THIS_SMALL = "tt-twitter-micro3.png";
    public static final String TWEET_THIS_ICON = "tweet-this.png";
    public static final String DELETED_DIRECTORY_ICON = "folder-deleted.png";
    public static final String FILE_ICON = "file.png";
    public static final String DELETED_FILE_ICON = "file-deleted.png";
    public static final int ICON_WIDTH = 15;
    public static final int ICON_HEIGHT = 13;

    private final ReportConfig config;
    private final String notesHTML;
    private List extraPages = new ArrayList();

    /**
     * @param config Configuration and data for the report suite
     * @param notesHTML A note to be inserted on top of the page; might be <tt>null</tt>
     */
    public ReportSuiteMaker(final ReportConfig config, final String notesHTML) {
        this(config, notesHTML, Collections.EMPTY_LIST);
    }

    /**
     * @param config Configuration and data for the report suite
     * @param notesHTML A note to be inserted on top of the page; might be <tt>null</tt>
     * @param additionalPages A list of {@link Page}s for inclusion in the index page's main menu
     */
    public ReportSuiteMaker(final ReportConfig config, final String notesHTML, final List additionalPages) {
        this.config = config;
        this.notesHTML = notesHTML;
        this.extraPages = additionalPages;
    }

    /**
    * this method will move away from the ordinary routine taken by
    * statSVn and will invoke some new classes that are written to generate the xml's
    * 
    */
    public void toXml() {
        new GenerateXml(this.config).generate();
    }

    /**
     * TODO: Don't throw exception
     * @throws IOException on error while writing the files
     */
    public Page toFile() throws IOException {
        this.config.getCssHandler().createOutputFiles();
        if (this.config.getRepository().isEmpty()) {
            return createEmptyRepositoryPage();
        }
        createIcon(TWEET_THIS_SMALL);
        createIcon(TWEET_THIS_ICON);
        createIcon(BUG_ICON);
        createIcon(DIRECTORY_ICON);
        createIcon(DELETED_DIRECTORY_ICON);
        createIcon(FILE_ICON);
        createIcon(DELETED_FILE_ICON);

        final PageGroup mainMenu = new PageGroup("Reports", false);
        mainMenu.add(new AllDevelopersPageMaker(this.config).toFile());
        mainMenu.add(new LogPageGroupMaker(this.config).getPages());
        mainMenu.add(new LOCPageMaker(this.config).toFile());
        mainMenu.add(new FileSizesPageMaker(this.config).toFile());
        mainMenu.add(new DirectorySizesPageMaker(this.config).toFile());
        mainMenu.add(new RepoMapPageMaker(config).toFile());
        mainMenu.add(new ChurnPageMaker(config).toFile());
        mainMenu.add(new CloudCommitPageMaker(this.config).toFile());
        Iterator it = this.extraPages.iterator();
        while (it.hasNext()) {
            mainMenu.add((Page) it.next());
        }
        final Page indexPage = new IndexPageMaker(this.config, this.notesHTML, mainMenu).toFile();

        final PageGroup directoryPages = new PageGroup("Directories", false);
        it = this.config.getRepository().getDirectories().iterator();
        while (it.hasNext()) {
            directoryPages.add(new DirectoryPageMaker(this.config, (Directory) it.next()).toFile());
        }
        indexPage.addChild(directoryPages);
        return indexPage;
    }

    private void createIcon(final String iconFilename) throws IOException {
        this.config.copyFileIntoReport(Main.class.getResource(WEB_FILE_PATH + iconFilename), iconFilename);
    }

    private Page createEmptyRepositoryPage() {
        String projectName = this.config.getProjectName();
        if (projectName == null) {
            projectName = "empty repository";
        }
        final String title = "Development statistics for " + projectName;
        final Page page = this.config.createPage("index", title, title);
        page.addAttribute("Generated", Calendar.getInstance().getTime());
        page.addRawContent("<p>No matching files in repository.</p>");
        return page;
    }
}