/*
 * StatsLog v2.0.x
 * Copyright (c) 2002 Chris Mason
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Debian system; see the file /usr/doc/copyright/GPL. If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite
 * 330, Boston, MA 02111-1307, USA.
 */

#define APPNAME "StatsLog"

#ifdef DEBUG
  #define VERSION "2.0.10 (Development Release)"
#else
  #define VERSION "2.0.10 (Stable Release)"
#endif 

#define COPYRIGHT "Copyright (c) 2002 Chris Mason (chris@k-rad.org)"

#define VERSION_REPLY "NOTICE %s :\1VERSION %s v%s - %s\1\r\n"

#define SL_LOG_VERSION "%s %s v%s\n"
#define SL_LOG_ERROR_VHOST "%s Error Binding To Virtual Host %s (%s)\n"
#define SL_LOG_ERROR_GETADDRINFO "%s Error Getting Address Information For %s (%s)\n"
#define SL_LOG_ERROR_SOCKET "%s Error Creating Connecting Socket For %s (%s)\n"
#define SL_LOG_CONNECTING "%s Attempting To Connect To %s On Port %d\n"
#define SL_LOG_ERROR_CONNECTING "%s Error Connecting To %s On Port %d (%s)\n"
#define SL_LOG_CONNECTED "%s Successfully Connected To %s On Port %d\n"
#define SL_LOG_CONNECTION_LOST "%s Lost Connection From %s\n"
#define SL_LOG_CONNECTION_TIMEDOUT "%s Error Connecting To %s On Port %d (Connection Timed Out)\n"
#define SL_LOG_CONNECTION_PINGTIMEOUT "%s Lost Connection From %s (Ping Timeout)\n"
#define SL_LOG_SEND_LOGIN "%s Sending Login Information To %s\n"
#define SL_LOG_THROTTLE_EXPIRE "%s Throttling Limit Expired For %s\n"
#define SL_LOG_LOGROTATE "%s Rotating %s Logs For %s\n"
#define SL_LOG_SUCCESS_LOGROTATE "%s Successfully Rotated %s Logs For %s\n"
#define SL_LOG_ERROR_LOGROTATE "%s Error Rotating %s Logs For %s\n"
#define SL_LOG_SIGHANDLER "%s Caught Signal %d... Terminating\n"
#define SL_LOG_GENERIC_CRLF "%s [%d][%s][%d] %s\n"
#define SL_LOG_GENERIC "%s [%d][%s][%d] %s"

#define STANDARD_TS_FORMAT "[%H:%M:%S]"
#define LOG_TS_FORMAT "%H:%M"
#define LONG_TS_FORMAT "%a %b %d %H:%M:%S %Y"
#define TOPIC_TS_FORMAT "%a %b %d %H:%M:%S"
#define ROTATE_TS_FORMAT "%M%H%d%m%w"

#define BUFFER_SIZE 4096
#define NICK_SIZE 32
#define HOST_SIZE 64
#define CHANNEL_SIZE 16
#define GENERIC_SIZE 255
#define LINE_SIZE 1024
#define CRON_SIZE 16
#define RAW_CODE_SIZE 8
#define PORT_SIZE 8
#define TIMESTAMP_SIZE 64

#define CONNECT_TIMEOUT 5
#define THROTTLE_LIMIT 5
#define JOIN_INTERVAL 2

#define NICK_COLLISION "433"
#define CHANNEL_TOPIC "332"
#define TOPIC_SET_BY "333"
#define CHANNEL_NAMES "353"

#define NICK_CMD "NICK %s\r\n"
#define USER_CMD "USER %s 0 0 :%s\r\n"
#define JOIN_CMD "JOIN %s\r\n"
#define PART_CMD "PART %s :%s\r\n"
#define PONG_CMD "PONG %s\r\n"
#define SPING_CMD "PRIVMSG %s :\1PING\1\r\n"

typedef struct {
  int minute;
  int hour;
  int dom;
  int month;
  int dow;
} CronDB;

typedef struct {
  char nick[NICK_SIZE];
} NickInfo;

typedef struct {
  char channel[CHANNEL_SIZE];
  char logrotate[CRON_SIZE];
  char lastrotate[CRON_SIZE];
  char logfile[GENERIC_SIZE];
  char archivelogfile[GENERIC_SIZE];
  char daterotateformat[GENERIC_SIZE];
  int daterotate;
  int status;
  int nCount;
  CronDB *cDB;
  NickInfo *nInfo;
} ChannelInfo;

typedef struct {
  short sockfd;
  char server[HOST_SIZE];
  char port[PORT_SIZE];
  char nick[NICK_SIZE];
  char ident[NICK_SIZE];
  char realname[GENERIC_SIZE];
  char rawcode[RAW_CODE_SIZE];
  char vhost[HOST_SIZE];
  char pingtimeout[PORT_SIZE];
  int selfping;
  char oldline[LINE_SIZE];
  char actualnick[NICK_SIZE];
  struct addrinfo *addrinfo;
  time_t timer;
  time_t stimer;
  time_t ptimer;
  int status;
  int cCount;
  ChannelInfo *cInfo;
} ServerInfo;

enum pStatus { csError = -1, csSuccess = 0 };
enum gStatus { csNone, csServer, csChannel };
enum sStatus { csBlank, csReady, csConnecting, csConnected, csAuthenticated, csThrottled };
enum cStatus { csKicked, csJoined, csRotatingLogs };

int resolve_servers(void);
struct addrinfo *resolve_host(char *, char *);
void write_file(char *, char *, ...);
char *gethost(struct addrinfo *);
int getport(struct addrinfo *);
void defrag_nicklist(int, int);
int crontab(CronDB *);
void LOG(long, char *, ...);
int select_fd_sets(fd_set *, fd_set *);
void connect_to_servers(void);
char *strip_codes(char *);
char *timestamp(char *);
void split_lines(char *, int, int);
void decode(char *, int);
void initiate_connect(int);
void reset_channel_status(int);
void send_login_sequence(int);
void healthcheck(void);
void rotate_logs(int, int);
void logrotate(void);
void daemonize(void);
void msleep(unsigned long);
void close_logs(int, int);
void sig_handler(int, siginfo_t *, void *);
void setup_signals(void);
void check_argc(int);
int sanity_check(void);
void generate_initial_info_struct(void);
void generate_new_server_struct(void);
void generate_initial_channel_struct(void);
void generate_new_channel_struct(void);
void parse_config(char *);
void show_version(void);
void free_memory(void);

