/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: auth.pike,v 1.1.1.1 2005/02/23 14:47:21 cvs Exp $
 */

inherit "/kernel/module";

#include <classes.h>
#include <database.h>
#include <events.h>

static object usermod = get_module("users");
static object ldap = get_module("ldap");

/**
 * Find a user object if the submitted password is sent correctly.
 *  
 * @param string name - the user name
 * @param string pass - the users password
 * @return the user object or null, throws an error if the password is wrong
 */
object authenticate(string name, string pass)
{
    object user = usermod->lookup(name);
    if ( objectp(user) ) {
	if ( user->get_activation() )
	    steam_error("User "+name+" not activated.");

	if ( objectp(ldap) && ldap->authorize_ldap(user, pass) )
	    return user;

	if ( user->check_user_password(pass) )
	    return user;
	steam_error("Wrong password for user '"+name+"'.");
    }
    else if ( objectp(ldap) ) {
	// try to create the user, if found in ldap
	user = ldap->sync(name, pass);
    }
    return user;
}

string get_ticket(object user)
{
  // try to get ticket from user and possible store inside ldap
}

string get_identifier() { return "auth"; }
