inherit "/classes/Script";
#include <macros.h>
#include <database.h>
#include <classes.h>
#include <events.h>
#include <attributes.h>

constant DEFAULT_ONTOLOGY="/visconte/Ontos/global/global.owl";
constant XSLT_PATH="/visconte/edit/stylesheets/";
constant TRANSLATION_PATH="/visconte/edit/translations/";
constant BROWSER_PATH="/visconte/browser/";
Visconte.StorageHandler.Steam store = Visconte.StorageHandler.Steam();				
Visconte.Onto.Ontology ont;
mapping(string:string)attr = ([ "lang":"english",
				"ontology":"",
				"ontologyVersion":"",
				"user":""
				]);
				
				

void set_ontology(object user, mapping vars)
{
	
	if(has_index(vars,"ontology"))
	{
		ont = Visconte.Onto.Ontology(vars->ontology,(int)vars["version"],store,(string)user->get_identifier());
		attr->ontology=vars->ontology;
	}
	else
	{
		ont = Visconte.Onto.Ontology(DEFAULT_ONTOLOGY,0,store,(string)user->get_identifier());
		attr->ontology=DEFAULT_ONTOLOGY;
	}
	attr->ontologyVersion=(string)ont->get_version();
	attr->user=(string)user->get_identifier();
	attr->lang=(string)user->query_attribute("USER_LANGUAGE");
	
}

int test_for_existence(string id)
{
	id=String.trim_whites(id);
	if(id=="" || id=="Thing")
		return 1;
	Visconte.Request.Action.GenericAction a = Visconte.Request.Action.GenericAction(ont);
	Visconte.Request.Result res = a->get_Item(Visconte.ID(id));
	return !res->has_error(11);
}



object get_MV_List(array result_mapping, mapping vars)
{
	Visconte.MVList list = Visconte.MVList();
	foreach(result_mapping, mapping attribute)
	{
		switch(attribute->tag_name)
		{
			case "association":
			if(has_index(vars,attribute->id))
			{
				list->add(Visconte.ID(attribute->id)->ref,Visconte.ID(vars[attribute->id])->ref);
			}
			break;
			
			case "property":
			if(has_index(vars,attribute->id))
			{
				string convertedType = setDataProperty(attribute->type,vars[attribute->id]);
				list->add(Visconte.ID(attribute->id)->ref,convertedType);
			}
			break;
		}
	}
	
	return list;
}

string setDataProperty(string type, string prop)
{
	string host = _Server->query_config(CFG_WEBSERVER);
	string port = (string) _Server->query_config("https_port");
	string uri="https://"+host+":"+port+"/";
	// string uri="https://whwhdjdkjdk.dedd.de/";
	
	
	switch (type)
	{
		case "steamDoc":
		if(!isURI(prop))
		return uri+getFilePath(prop);
		break;
		
		case "steamUser":
		if(!isURI(prop))
		return uri+"/home/"+prop;
		break;
		
		case "steamContainer":
		if(!isURI(prop))
		return uri+getFilePath(prop);
		break;
		
		case "steamGroup":
		if(!isURI(prop))
		return uri+"/groups/"+prop;
		break;
		
	}
	
	return prop;
}

string getFilePath(string file)
{
	
	 // object file = find_object((int)file);
	 // if(!file)
		//  file = find_object(file);
	 // if(file)
		//  return _FILEPATH->object_to_filename(file);
	 // else
		 return file;
	
	
	 
}

int isURI(string ref)
{
	 return(has_value(ref, "://"));
}
