/* Copyright (C) 2000-2004  Thomas Bopp, Thorsten Hampel, Ludger Merkens
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 * 
 * $Id: users.pike,v 1.1.1.1 2006/03/27 12:40:12 exodusd Exp $
 */

constant cvs_version="$Id: users.pike,v 1.1.1.1 2006/03/27 12:40:12 exodusd Exp $";

inherit "/kernel/secure_mapping.pike";

#include <macros.h>
#include <database.h>
#include <classes.h>

//! This module keeps track of the users in the database. -
//! Therefor it maps a nickname to the related sTeam user object.

object lookup(string index)
{
  object user = ::lookup(index);
  if ( !objectp(user) )
    return _Persistence->lookup_user(index);
  return user;
}

string rename_user(object user, string new_name)
{
  if ( CALLER != get_factory(CLASS_USER) )
    steam_error("Invalid call to rename_user() !");
  object other = get_value(new_name);
  if ( objectp(other) && other != user )
    steam_error("There is already a user with the name '"+new_name+"' !");
  string name = user->get_user_name();
  set_value(name, 0);
  set_value(new_name, user);
  return new_name;
}

object get_user ( string name )
{
  return get_value(name);
}

string get_identifier() { return "users"; }
string get_table_name() { return "users"; }

