//============================================================================
//
//   SSSS    tt          lll  lll
//  SS  SS   tt           ll   ll
//  SS     tttttt  eeee   ll   ll   aaaa
//   SSSS    tt   ee  ee  ll   ll      aa
//      SS   tt   eeeeee  ll   ll   aaaaa  --  "An Atari 2600 VCS Emulator"
//  SS  SS   tt   ee      ll   ll  aa  aa
//   SSSS     ttt  eeeee llll llll  aaaaa
//
// Copyright (c) 1995-2020 by Bradford W. Mott, Stephen Anthony
// and the Stella Team
//
// See the file "License.txt" for information on usage and redistribution of
// this file, and for a DISCLAIMER OF ALL WARRANTIES.
//============================================================================

#ifndef EVENTHANDLER_SDL2_HXX
#define EVENTHANDLER_SDL2_HXX

#include "SDL_lib.hxx"
#include "EventHandler.hxx"
#include "PhysicalJoystick.hxx"

/**
  This class handles event collection from the point of view of the specific
  backend toolkit (SDL2).  It converts from SDL2-specific events into events
  that the Stella core can understand.

  @author  Stephen Anthony
*/
class EventHandlerSDL2 : public EventHandler
{
  public:
    /**
      Create a new SDL2 event handler object
    */
    explicit EventHandlerSDL2(OSystem& osystem);
    virtual ~EventHandlerSDL2();

  private:
    /**
      Enable/disable text events (distinct from single-key events).
    */
    void enableTextEvents(bool enable) override;

    /**
      Collects and dispatches any pending SDL2 events.
    */
    void pollEvent() override;

  private:
    SDL_Event myEvent;

    // A thin wrapper around a basic PhysicalJoystick, holding the pointer to
    // the underlying SDL joystick device.
    class JoystickSDL2 : public PhysicalJoystick
    {
      public:
        explicit JoystickSDL2(int idx);
        virtual ~JoystickSDL2();

      private:
        SDL_Joystick* myStick;
    };

  private:
    // Following constructors and assignment operators not supported
    EventHandlerSDL2() = delete;
    EventHandlerSDL2(const EventHandlerSDL2&) = delete;
    EventHandlerSDL2(EventHandlerSDL2&&) = delete;
    EventHandlerSDL2& operator=(const EventHandlerSDL2&) = delete;
    EventHandlerSDL2& operator=(EventHandlerSDL2&&) = delete;
};

#endif
