Language Reference
==================

This section of the documentation covers the fundamentals of Storm, and the languages that are built
in by default (Basic Storm and the Syntax Language). These two languages will then be used for
examples in the remainder of the documentation.

The language reference consists of the following sections:

- [Storm](md:Storm): Covers the language independent mechanisms that Storm provides to language
  implementations.

- [Basic Storm](md:Basic_Storm): Covers the language Basic Storm. It is designed to be a
  language with features that closely matches those provided by Storm. Because of the close mapping
  between Basic Storm and the underlying concepts, it is useful to understand the underlying
  concepts in Storm.

- [The Syntax Language](md:The_Syntax_Language): Covers the Syntax Language. Similarly to Basic
  Storm, the Syntax Language closely matches the underlying representation of syntax that is
  provided by Storm.

- [Intermediate Language](md:Intermediate_Language): Covers the platform independent
  intermediate language provided by Storm. This language is emitted by languages in the system and
  then transformed into executable machine code by Storm. Since this language is intended to be
  generated by other languages, it is implemented as a library and has no textual representation by
  default.

The language reference does not cover libraries in detail. These are instead covered in the [library reference](md:/Library_Reference).
