use experimental:effects;
use lang:bs:macro;
use test;

effect myEffect(Int x)->Int;

handler MyHandler(Int->Float) {
	myEffect(Int x), k {
		print("In handler, x = ${x}");
		Float sum = 0;
		for (Int i = 0; i < times; i++) {
			sum += k.call(x + i);
		}
		sum += 0.5;
		print("Returning ${sum}");
		return sum;
	}
	return x {
		print("In return handler: ${x}, ${times}");
		return (x + 1).float;
	}

	Int times;

	init() {
		init { times = 1; }
	}

	init(Int times) {
		init { times = times; }
	}
}

suite Basic {
	Float w = with MyHandler(2) handle {
		Int x = myEffect(1);
		print("x = ${x}");
		Int y = myEffect(x + 100);
		print("y = ${y}");
		y;
	};

	test w == 413.5;
	print("Result: ${w}");
}

effect fork()->Int;

handler ForkHandler(Int->Int) {
	fork(), cont {
		Int first = cont.call(1);
		Int second = cont.call(2);
		return first + second;
	}
}

suite Fork {
	Int result = with ForkHandler handle {
		Int x = fork();
		return x * 2;
	};
	test result == 6;
}
