/*
*
* $Source: /var/cvs/plode/texture.cxx,v $
* $Revision: 1.5 $
* $Author: stolk $
* $Date: 2005-08-08 07:30:41 $
*
* by Raymond de Vries
*
*/

#ifdef _WIN32
#include <windows.h>
#endif
#include <string.h>
#include <assert.h>
#include <GL/gl.h>

#include "texture.h"
#include "tga.h"


Texture::Texture(const std::string &filename) : id(0) 
{
  if(strcmp(strrchr(filename.c_str(), '.'), ".tga") == 0) 
  {
    CTga *tga = new CTga();

    // Note: This will always make a 32-bit texture
    if(tga->ReadFile(filename.c_str()) == 0) 
    {
      fprintf(stderr,"Could not read tga file '%s'\n", filename.c_str());
      tga->Release();
      return;
    }

    // Flip texture
    width  = tga->GetSizeX();
    height = tga->GetSizeY();
    depth  = tga->Bpp() / 8;

    texData = new unsigned char[width * height * depth];

    for(int y = 0; y < height; ++y) 
    {
      memcpy
      (
        texData + y * width * depth,
        &((unsigned char*)tga->GetPointer())[(height - y - 1) * width * depth], 
        width * depth
      );
    }
    tga->Release();
  }
}


void Texture::ScaleColour(float sr, float sg, float sb, float sa)
{
  assert(depth == 4);
  for (int i=0; i<width*height; i++)
  {
    texData[i*4+0] = int(texData[i*4+0]*sr);
    texData[i*4+1] = int(texData[i*4+1]*sg);
    texData[i*4+2] = int(texData[i*4+2]*sb);
    texData[i*4+3] = int(texData[i*4+3]*sa);
  }
}


void Texture::InitForRendering(void) 
{
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  glGenTextures(1, &id);

  glBindTexture(GL_TEXTURE_2D, id);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);

  glTexImage2D
  (
    GL_TEXTURE_2D, 
    0, 
    ((depth == 3) ? GL_RGB : GL_RGBA),
    width, height, 
    0, 
    ((depth == 3) ? GL_RGB : GL_RGBA) , 
    GL_UNSIGNED_BYTE, 
    texData
  );
}


void Texture::Activate(void) 
{
  glBindTexture(GL_TEXTURE_2D, id);
}

