#import "Globals.h"

// The informal InstallerDownloadController protocol
@interface NSObject ( InstallerDownloadController )

	- (void)downloadProgress:(id)sender value:(double)value;
	- (void)downloadFailed:(id)sender reason:(NSString *)reason;

@end

// The informal InstallerDownload protocol
@interface NSObject ( InstallerDownload )

	- (NSURL *)downloadURL;
	- (int)downloadSize;
	- (NSString *)destinationPath;

@end

@interface InstallerDownload : NSObject <NSURLHandleClient>
{

	// The selector to be called upon completion of all downloads
	SEL callbackSelector;
	
	// The array of objects which give information on what we are downloading
	NSArray *downloads;
	
	// The index of the URL which is currently being downloaded
	int currentDownload;
	
	// The total size of all downloads
	int totalDownloadSize;
	
	// How much of the current download has already passed
	int curDownloadSize;
	
	// The size of the progress bar to be filled after completion
	double progressSize;
	
	// The client object
	id client;
	
	// The NSURLHandle that does the downloading
	NSURLHandle *downloader;
	
	// Prevent multiple complaints
	BOOL complained;
	
	// Is the downloader downloading?
	BOOL isDownloading;
	
}

// Creates the download manager with a given client object
// The client must implement the callback method and may implement the informal InstallerDownloadController protocol
- (id)initWithClient:(id)newClient;

// Resets instance for further use releasing download URLs and destination paths
-(void)reset;

// Prepares the instance for destruction
- (void)dealloc;

// Commences downloading where downloadObjects is an array of objects conforming to the informal InstallerDownload protocol
// Returns success, failure will result if downloading is currently taking place
- (BOOL)commenceDownloads:(NSArray *)downloadObjects withCallback:(SEL)callback;

// The name of the file currently being downloaded to
- (NSString *)currentDownloadName;

// Returns YES if object is downloading
- (BOOL)isDownloading;

// Sets the size of the progress bar to be filled after completion
- (void)setProgressSize:(double)size;

@end
