#import "Globals.h"

#define kMediaDownloadURL	@"http://umn.dl.sourceforge.net/sourceforge/freecraft/fcmp-030311.tar.gz"
#define kMediaPackageName	@"fcmp-030311.tar.gz"
#define kMediaPackageSize	8338255

@interface InstallerMedia : NSObject
{
	
	// The label and set of radio buttons associated with this segment of the installer
    IBOutlet id label;
    IBOutlet id radios;

	// The controller
	IBOutlet id controller;
	
	// A direct move occurs when a "data" folder is selected by the user
	BOOL directMove;
	NSString *directMovePath;
	
	// A shift is needed if the component is not in the "Components" directory
	BOOL shiftNeeded;
	NSString *shiftPath;
	
	// Has the file necessary for installation already been downloaded?
	BOOL alreadyDownloaded;
	
}

// Called upon a change of selection by the user
- (IBAction)choiceChanged:(id)sender;

// Returns the path of where the file should be downloaded to
- (NSString *)destinationPath;

// Returns the URL for downloading the package or NULL if no download is necessary
- (NSURL *)downloadURL;

// Returns the expected size of the download or 0 if no download is necessary
- (int)downloadSize;

// Expands the media into FreeCraft
- (BOOL)expand;

// Called to initialize various data member
- (id)init;

// Called to prepare for installation
- (BOOL)prepare;

// Sets things up for the user
- (void)setup;

// Returns whether or not low resolution should be used
- (BOOL)useLowRes;

@end
