#import "Globals.h"

// The informal InstallerTools protocol
@interface NSObject ( InstallerTools )

	- (void)toolFailed:(id)sender named:(NSString *)name code:(int)code;

@end

@interface InstallerTools : NSObject
{
	// The objects client this object may implement the above informal protocol and more
	id client;
	
	// The currently executing task
	NSTask *task;
	
}

// Prepares tools for running, client may implement the above informal protocol
- (id)initWithClient:(id)newClient;

// Decompress a given zip file
- (BOOL)gunzip:(NSString *)file;

// Compress a given zip file
- (BOOL)gzip:(NSString *)file;

// Expand a given archive to the given directory
- (BOOL)tar:(NSString *)file destination:(NSString *)directory;

@end
