module test7
signature
  constructors
    Nil   : List(a)
    Cons  : a * List(a) -> List(a)

    Zero  : Nat
    Succ  : Nat -> Nat
    Plus  : Nat * Nat -> Nat

rules

  A : Plus(Zero, x) -> x
  B : Plus(Succ(x), y) -> Plus(x, Succ(y))

strategies

  try(s) = s <+ id
 
  repeat(s) = 
    rec x(try(s; x))

  eval = 
    repeat(A + B)

  main =  
    !Plus(Succ(Succ(Zero)), Succ(Zero));
    eval
