cvs_id = "$Id: StrawURLOpener.py,v 1.2 2004/04/16 20:26:07 jpakaste Exp $"

from urllib import FancyURLopener, URLopener
import gzip
try:
    from cStringIO import StringIO
except:
    from StringIO import StringIO
import straw
from error import log, logparam

class StrawURLOpener(FancyURLopener):
    def __init__(self, username = None, password = None, *args):
        self.version = "Straw/%s" % straw.VERSION
        self._username = username
        self._password = password
        FancyURLopener.__init__(self, *args)
        self.addheader('Accept-encoding', 'gzip')
        self._authentication_tried = False
        return

    def prompt_user_passwd(self, host, realm):
        if self._authentication_tried:
            return (None, None)
        else:
            self._authentication_tried = True
            return (self._username, self._password)

    def http_error_default(self, url, fp, errcode, errmsg, headers):
        URLopener.http_error_default(self, url, fp, errcode, errmsg, headers)

    def readurl(self, url):
        handle = self.open(url)
        info = handle.info()
        data = handle.read()
        if info.getheader('content-encoding') == 'gzip':
            data = gzip.GzipFile(fileobj = StringIO(data)).read()
        handle.close()
        return info, data
