# Copyright (c) 2002 Juri Pakaste
# You may use and distribute this software under the terms of the
# GNU General Public License, version 2 or later

cvs_id = "$Id: SummaryItem.py,v 1.2 2004/04/16 20:26:07 jpakaste Exp $"

import straw
import time

class SummaryItem(object, straw.SignalEmitter):
    __slots__ = ('title', 'link', 'description', 'guid', 'pub_date', 'source',
                 '_images', '_seen', '_id', 'feed', '_slots',
                 'fm_license', 'fm_changes', 'creator', 'license_urls',
                 '_searchable_fields', '_sticky', 'publication_name',
                 'publication_volume', 'publication_number',
                 'publication_section', 'publication_starting_page',
                 'title_converted', 'guidislink')

    _searchable_fields = ('title', 'description', 'fm_license', 'fm_changes',
                          'creator')

    def __init__(self):
        straw.SignalEmitter.__init__(self)
        self.initialize_slots(straw.ItemReadSignal, straw.ItemStickySignal)
        self.title = None
        self.link = None
        self.description = None
        self.guid = None
        self.guidislink = True
        self.pub_date = time.localtime()
        self.source = None
        self._images = {}
        self._seen = 0
        self._id = None
        self.feed = None
        self.fm_license = None
        self.fm_changes = None
        self.creator = None
        self.license_urls = []
        self.publication_name = None
        self.publication_volume = None
        self.publication_number = None
        self.publication_section = None
        self.publication_starting_page = None
        self._sticky = 0
        self.title_converted = False

    def _add_image(self, image_name, restore):
        straw.ImageCache.cache.add_refer(image_name, restore, self)
        self._images[image_name] = straw.ImageCache.cache[image_name]

    def add_image(self, image_name):
        self._add_image(image_name, restore = False)

    def restore_image(self, image_name):
        self._add_image(image_name, restore = True)

    def set_image(self, image_name, image):
        self._images[image_name] = image
        
    def get_image(self, image_name):
        return self._images.get(image_name, None)

    def clear_images(self):
        self._images = {}

    def image_keys(self):
        return self._images.keys()

    def is_seen(self):
        return self._seen

    def set_seen(self, seen = 1):
        oldseen = self._seen
        self._seen = seen
        if seen != oldseen:
            self.emit_signal(straw.ItemReadSignal(self))

    seen = property(is_seen, set_seen, None, "")

    def is_sticky(self):
        return self._sticky

    def set_sticky(self, sticky):
        self._sticky = sticky
        self.emit_signal(straw.ItemStickySignal(self))

    sticky = property(is_sticky, set_sticky, None, "")

    def set_seen_quiet(self, seen = 1):
        old = self._seen
        self._seen = seen
        return seen != old

    def set_id(self, id):
        self._id = id

    def get_id(self):
        return self._id

    id = property(get_id, set_id, None, "Internal id")

    def match(self, text):
        def try_field(field):
            return type(field) in (
                type(''), type(u'')) and field.lower().find(text.lower()) > -1
        for f in self._searchable_fields:
            try:
                if try_field(self.__getattribute__(f)):
                    return 1
            except AttributeError:
                pass
        return 0

    def clean_up(self):
        for image in self._images:
            straw.ImageCache.cache.remove_refer(image)
