#include "fileinputstream.h"
#include "stringreader.h"
#include "gzipinputstream.h"
#include "kmpsearcher.h"
using namespace jstreams;

bool
isPdfWhitespace(char c) {
    return c==0x00||c==0x09||c==0x0A||c==0x0C||c==0x0D||c==0x20;
}
bool
isPdfDelimiter(char c) {
    return c=='('||c==')'||c=='<'||c=='>'||c=='['||c==']'||c=='{'||c=='}'
        ||c=='/'||c=='%';
}

/**
 * Read the stream from the current position while maintaining the possibility
 * to reset to position pos.
 **/
int32_t
readMore(StreamBase<char>* s, int64_t pos, const char*& c,
        int32_t min, int32_t max) {
    int64_t p = s->getPosition();
    int32_t off = (int32_t)(p-pos);
    if (s->reset(pos) != pos) return -1;
    int32_t n = s->read(c, off+min, max);
    if (n < 0) return n;
    if (n < off) return -1;
    c += off;
    return n-off;
}
int32_t
peek(StreamBase<char>* s, int64_t pos, const char*& c,
        int32_t min, int32_t max) {
    int64_t p = s->getPosition();
    int32_t n = readMore(s, pos, c, min, max);
    s->reset(p);
    return n;
}

/**
 * after each parse* or skip* function, the stream is positioned after the
 * object that was parsed. It should still be possible to reset(pos) with the
 * position that was provided.
 **/

int32_t skipWhitespace(int64_t pos, StreamBase<char>* s);
int32_t parseObjectStreamObject(int64_t pos, StreamBase<char>* s);
int32_t parseComment(int64_t pos, StreamBase<char>* s);
int32_t parseBoolean(int64_t pos, StreamBase<char>* s);
int32_t parseNumber(int64_t pos, StreamBase<char>* s);
int32_t parseNumberOrIndirectObject(int64_t pos, StreamBase<char>* s);
int32_t parseLiteralString(int64_t pos, StreamBase<char>* s);
int32_t parseHexString(int64_t pos, StreamBase<char>* s);
int32_t parseDictionaryOrStream(int64_t pos, StreamBase<char>* s);
int32_t parseArray(int64_t pos, StreamBase<char>* s);
int32_t parseNull(int64_t pos, StreamBase<char>* s);

bool
isInString(char c, const char* s, int32_t n) {
    for (int i=0; i<n; ++i) {
        if (s[i] == c) return true;
    }
    return false;
}
int32_t
skipFromString(int64_t pos, StreamBase<char>* s, const char*str, int32_t n) {
    int64_t cpos = s->getPosition();
    const char* c;
    int32_t n;
    int32_t p = 0;
    do {
        n = peek(s, pos, c, p+1, 0);
        if (n <= 0) return n;
        while (p < n && isInString(c, str, n)) p++;
    } while (p >= n);
    s->reset(cpos+p);
    return p;
}
int32_t
skipNotFromString(int64_t pos, StreamBase<char>* s, const char*str, int32_t n) {
    int64_t cpos = s->getPosition();
    const char* c;
    int32_t n;
    int32_t p = 0;
    do {
        n = peek(s, pos, c, p+1, 0);
        if (n <= 0) return n;
        while (p < n && !isInString(c, str, n)) p++;
    } while (p >= n);
    s->reset(cpos+p);
    return p;
}
/**
 * Skip whitespace in the stream. Return amount of whitespace skipped.
 * After calling this function the position in the stream is after the
 * whitespace.
 **/
int32_t
skipWhitespace(int64_t pos, StreamBase<char>* s) {
    return skipFromString(pos, s, "\t\n\f\r ", 5);
}
int32_t
parseComment(int64_t pos, StreamBase<char>* s) {
    const char* c;
    int32_t n = s->read(s, 1, 1);
    if (n != 1) {
        return -1;
    }
    return skipNotFromString(pos, s, "\r\n", 2);
}
int32_t
parseBoolean(int64_t pos, StreamBase<char>* s) {
    int64_t cpos = s->getPosition();
    const char* c;
    int32_t n = peek(s, pos, c, 5, 0);
    if (n >= 4 && strncmp("true", c, 4) == 0) {
        s->reset(cpos+4);
        return 4;
    } else if (n >= 5 && strncmp("false", c, 5) == 0) {
        s->reset(cpos+5);
        return 5;
    }
    return -1;
}
// - number : [+-]?\d+(.\d+)?
int32_t
parseNumber(int64_t pos, StreamBase<char>* s) {
    int64_t cpos = s->getPosition();
    const char* c;
    int32_t n = peek(s, pos, c, 2, 0);
    if (n <= 0) return -1;
    int32_t p = 0;
    if (c[p] == '+' || c[p] == '-') p++;
    bool dot = false;
    do {
        n = peek(s, pos, c, p+1, 0);
        if (n <= 0) return n;
        while (p < n && c[p]==10 || c[p]==13) p++;
    } while (p >= n);
    while (p < 
    const char* end;
    if (sscanf(c, "") != 1) {
    }
}
int32_t
parseNumberOrIndirectObject(int64_t pos, StreamBase<char>* s) {
}
int32_t
parseLiteralString(int64_t pos, StreamBase<char>* s) {
}
int32_t
parseHexString(int64_t pos, StreamBase<char>* s) {
}
int32_t
parseDictionaryOrStream(int64_t pos, StreamBase<char>* s) {
}
int32_t
parseArray(int64_t pos, StreamBase<char>* s) {
}
int32_t
parseNull(int64_t pos, StreamBase<char>* s) {
}
int32_t
parseObjectStreamObject(int64_t pos, StreamBase<char>* s) {
    const char* c;
    int32_t n = peek(s, pos, c, 2, 0);
    if (n <= 0) return -1;

    // skip whitespace
    int32_t ws = skipWhitespace(pos, s);
    if (ws < 0) return ws;

    int os = 1; // object size
    char ch = c[0];
    if (ch == '%') {
        os = parseComment(pos, s);
    } else if (ch == 't' || ch == 'f') {
        os = parseBoolean(pos, s);
    } else if (ch == '+' || ch == '-' || ch == '.' || isdigit(ch)) {
        os = parseNumberOrIndirectObject(pos, s);
    } else if (ch == '(') {
        os = parseLiteralString(pos, s);
    } else if (ch == '<') {
        if (n > 1 && c[1] == '<') {
            os = parseDictionaryOrStream(pos, s);
        } else {
            os = parseHexString(pos, s);
        }
    } else if (ch == '[') {
        os = parseArray(pos, s);
    } else if (ch == 'n') {
        os = parseNull(pos, s);
    }
    s->reset(pos);
    return os;
}

void
parseObjectStream(StreamBase<char>* s) {
}

int
main(int argc, char** argv) {

    for (int i=1; i<argc; ++i) {
        FileInputStream file(argv[i]);
        parseObjectStream(&file);
    }
    return 0;
}
