// generated by makecode.pl
#include "dbusxesamlivesearchinterface.h"
#include "/home/oever/code/strigi/src/daemon/dbus/dbusserialization.h"
#include <dbusobjectinterface.h>
#include <dbusmessagereader.h>
#include <dbusmessagewriter.h>
#include <sstream>
class PrivateDBusXesamLiveSearchInterface : public DBusObjectInterface {
private:
    DBusXesamLiveSearchInterface& impl;
    typedef void (PrivateDBusXesamLiveSearchInterface::*handlerFunction)
        (DBusMessage* msg, DBusConnection* conn);
    std::map<std::string, handlerFunction> handlers;
    DBusHandlerResult handleCall(DBusConnection*c,DBusMessage* m);
    std::string getIntrospectionXML();
    void GetState(DBusMessage* msg, DBusConnection* conn);
    void StartSearch(DBusMessage* msg, DBusConnection* conn);
    void GetHits(DBusMessage* msg, DBusConnection* conn);
    void NewSession(DBusMessage* msg, DBusConnection* conn);
    void CloseSession(DBusMessage* msg, DBusConnection* conn);
    void GetHitData(DBusMessage* msg, DBusConnection* conn);
    void SetProperty(DBusMessage* msg, DBusConnection* conn);
    void NewSearch(DBusMessage* msg, DBusConnection* conn);
    void CountHits(DBusMessage* msg, DBusConnection* conn);
    void GetProperty(DBusMessage* msg, DBusConnection* conn);
    void CloseSearch(DBusMessage* msg, DBusConnection* conn);
public:
    PrivateDBusXesamLiveSearchInterface(DBusXesamLiveSearchInterface& i);
};
PrivateDBusXesamLiveSearchInterface::PrivateDBusXesamLiveSearchInterface(DBusXesamLiveSearchInterface& i)
        :DBusObjectInterface("org.freedesktop.xesam.Search"), impl(i) {
    handlers["GetState"] = &PrivateDBusXesamLiveSearchInterface::GetState;
    handlers["StartSearch"] = &PrivateDBusXesamLiveSearchInterface::StartSearch;
    handlers["GetHits"] = &PrivateDBusXesamLiveSearchInterface::GetHits;
    handlers["NewSession"] = &PrivateDBusXesamLiveSearchInterface::NewSession;
    handlers["CloseSession"] = &PrivateDBusXesamLiveSearchInterface::CloseSession;
    handlers["GetHitData"] = &PrivateDBusXesamLiveSearchInterface::GetHitData;
    handlers["SetProperty"] = &PrivateDBusXesamLiveSearchInterface::SetProperty;
    handlers["NewSearch"] = &PrivateDBusXesamLiveSearchInterface::NewSearch;
    handlers["CountHits"] = &PrivateDBusXesamLiveSearchInterface::CountHits;
    handlers["GetProperty"] = &PrivateDBusXesamLiveSearchInterface::GetProperty;
    handlers["CloseSearch"] = &PrivateDBusXesamLiveSearchInterface::CloseSearch;
}
DBusHandlerResult
PrivateDBusXesamLiveSearchInterface::handleCall(DBusConnection*connection, DBusMessage* msg) {
    std::map<std::string, handlerFunction>::const_iterator h;
    const char* i = getInterfaceName().c_str();
    for (h = handlers.begin(); h != handlers.end(); ++h) {
        if (dbus_message_is_method_call(msg, i, h->first.c_str())) {
            (this->*h->second)(msg, connection);
            return DBUS_HANDLER_RESULT_HANDLED;
        }
    }
    return DBUS_HANDLER_RESULT_NOT_YET_HANDLED;
}
std::string
PrivateDBusXesamLiveSearchInterface::getIntrospectionXML() {
    std::ostringstream xml;
    xml << "  <interface name='"+getInterfaceName()+"'>\n"
    << "    <method name='GetState'>\n"
    << "      <arg name='out' type='as' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='StartSearch'>\n"
    << "      <arg name='search' type='s' direction='in'/>\n"
    << "    </method>\n"
    << "    <method name='GetHits'>\n"
    << "      <arg name='search' type='s' direction='in'/>\n"
    << "      <arg name='num' type='i' direction='in'/>\n"
    << "      <arg name='hits' type='aav' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='NewSession'>\n"
    << "      <arg name='out' type='s' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='CloseSession'>\n"
    << "      <arg name='session' type='s' direction='in'/>\n"
    << "    </method>\n"
    << "    <method name='GetHitData'>\n"
    << "      <arg name='search' type='s' direction='in'/>\n"
    << "      <arg name='hit_ids' type='ai' direction='in'/>\n"
    << "      <arg name='properties' type='as' direction='in'/>\n"
    << "      <arg name='v' type='aav' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='SetProperty'>\n"
    << "      <arg name='session' type='s' direction='in'/>\n"
    << "      <arg name='prop' type='s' direction='in'/>\n"
    << "      <arg name='v' type='v' direction='in'/>\n"
    << "      <arg name='out' type='v' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='NewSearch'>\n"
    << "      <arg name='session' type='s' direction='in'/>\n"
    << "      <arg name='query_xml' type='s' direction='in'/>\n"
    << "      <arg name='out' type='s' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='CountHits'>\n"
    << "      <arg name='search' type='s' direction='in'/>\n"
    << "      <arg name='count' type='i' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='GetProperty'>\n"
    << "      <arg name='session' type='s' direction='in'/>\n"
    << "      <arg name='prop' type='s' direction='in'/>\n"
    << "      <arg name='out' type='v' direction='out'/>\n"
    << "    </method>\n"
    << "    <method name='CloseSearch'>\n"
    << "      <arg name='search' type='s' direction='in'/>\n"
    << "    </method>\n"
    << "    <signal name='HitsModified'>\n"
    << "      <arg name='search' type='s'/>\n"
    << "      <arg name='hit_ids' type='ai'/>\n"
    << "    </signal>\n"
    << "    <signal name='HitsRemoved'>\n"
    << "      <arg name='search' type='s'/>\n"
    << "      <arg name='hit_ids' type='ai'/>\n"
    << "    </signal>\n"
    << "    <signal name='HitsAdded'>\n"
    << "      <arg name='search' type='s'/>\n"
    << "      <arg name='count' type='i'/>\n"
    << "    </signal>\n"
    << "  </interface>\n";
    return xml.str();
}
void
PrivateDBusXesamLiveSearchInterface::GetState(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    if (reader.isOk()) {
        writer << impl.GetState();
    }
}
void
PrivateDBusXesamLiveSearchInterface::StartSearch(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    std::string search;
    reader >> search;
    if (reader.isOk()) {
        impl.StartSearch(search);
    }
}
void
PrivateDBusXesamLiveSearchInterface::GetHits(DBusMessage* dbm, DBusConnection* conn) {
    DBusMessageReader reader(dbm);
    std::string search;
    int32_t num;
    reader >> search >> num;
    if (reader.isOk()) {
        dbus_message_ref(dbm);
        impl.GetHits(dbm, search,num);
    }
}
void
PrivateDBusXesamLiveSearchInterface::NewSession(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    if (reader.isOk()) {
        writer << impl.NewSession();
    }
}
void
PrivateDBusXesamLiveSearchInterface::CloseSession(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    std::string session;
    reader >> session;
    if (reader.isOk()) {
        impl.CloseSession(session);
    }
}
void
PrivateDBusXesamLiveSearchInterface::GetHitData(DBusMessage* dbm, DBusConnection* conn) {
    DBusMessageReader reader(dbm);
    std::string search;
    std::vector<int32_t> hit_ids;
    std::vector<std::string> properties;
    reader >> search >> hit_ids >> properties;
    if (reader.isOk()) {
        dbus_message_ref(dbm);
        impl.GetHitData(dbm, search,hit_ids,properties);
    }
}
void
PrivateDBusXesamLiveSearchInterface::SetProperty(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    std::string session;
    std::string prop;
    Strigi::Variant v;
    reader >> session >> prop >> v;
    if (reader.isOk()) {
        writer << impl.SetProperty(session,prop,v);
    }
}
void
PrivateDBusXesamLiveSearchInterface::NewSearch(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    std::string session;
    std::string query_xml;
    reader >> session >> query_xml;
    if (reader.isOk()) {
        writer << impl.NewSearch(session,query_xml);
    }
}
void
PrivateDBusXesamLiveSearchInterface::CountHits(DBusMessage* dbm, DBusConnection* conn) {
    DBusMessageReader reader(dbm);
    std::string search;
    reader >> search;
    if (reader.isOk()) {
        dbus_message_ref(dbm);
        impl.CountHits(dbm, search);
    }
}
void
PrivateDBusXesamLiveSearchInterface::GetProperty(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    std::string session;
    std::string prop;
    reader >> session >> prop;
    if (reader.isOk()) {
        writer << impl.GetProperty(session,prop);
    }
}
void
PrivateDBusXesamLiveSearchInterface::CloseSearch(DBusMessage* msg, DBusConnection* conn) {
    DBusMessageReader reader(msg);
    DBusMessageWriter writer(conn, msg);
    std::string search;
    reader >> search;
    if (reader.isOk()) {
        impl.CloseSearch(search);
    }
}
DBusXesamLiveSearchInterface::DBusXesamLiveSearchInterface(const std::string& on, DBusConnection* c, XesamLiveSearchInterface* x) 
        :XesamLiveSearchInterface(x), object(on), conn(c), iface(new PrivateDBusXesamLiveSearchInterface(*this)) {}
DBusXesamLiveSearchInterface::~DBusXesamLiveSearchInterface() {
    delete iface;
}
void
DBusXesamLiveSearchInterface::GetHitsResponse(void* msg,             const std::vector<std::vector<Strigi::Variant> >& hits) {
    DBusMessage* m = static_cast<DBusMessage*>(msg);
    DBusMessageWriter writer(conn, m);
    writer << hits;
    dbus_message_unref(m);
}
void
DBusXesamLiveSearchInterface::GetHitDataResponse(void* msg,             const std::vector<std::vector<Strigi::Variant> >& v) {
    DBusMessage* m = static_cast<DBusMessage*>(msg);
    DBusMessageWriter writer(conn, m);
    writer << v;
    dbus_message_unref(m);
}
void
DBusXesamLiveSearchInterface::CountHitsResponse(void* msg, int32_t count) {
    DBusMessage* m = static_cast<DBusMessage*>(msg);
    DBusMessageWriter writer(conn, m);
    writer << count;
    dbus_message_unref(m);
}
void
DBusXesamLiveSearchInterface::HitsModified(const std::string& search,         const std::vector<int32_t>& hit_ids) {
    DBusMessageWriter writer(conn, object.c_str(), "org.freedesktop.xesam.Search", "HitsModified");
    writer << search << hit_ids;
}
void
DBusXesamLiveSearchInterface::HitsRemoved(const std::string& search,         const std::vector<int32_t>& hit_ids) {
    DBusMessageWriter writer(conn, object.c_str(), "org.freedesktop.xesam.Search", "HitsRemoved");
    writer << search << hit_ids;
}
void
DBusXesamLiveSearchInterface::HitsAdded(const std::string& search, const int32_t count) {
    DBusMessageWriter writer(conn, object.c_str(), "org.freedesktop.xesam.Search", "HitsAdded");
    writer << search << count;
}
