/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef _jstream_H_
#define _jstream_H_

#include <qstring.h>
#include <qcstring.h>

#include <kurl.h>
#include <kio/global.h>
#include <kio/slavebase.h>

class QCString;
namespace jstreams {
    class ArchiveReader;
}
class QFileStreamOpener;

class kio_jstreamProtocol : public KIO::SlaveBase
{
private:
    jstreams::ArchiveReader* reader;
    QFileStreamOpener* opener;
public:
    kio_jstreamProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~kio_jstreamProtocol();
    virtual void mimetype(const KURL& url);
    virtual void get(const KURL& url);
    virtual void stat(const KURL& url);
    virtual void listDir(const KURL& url);
};

#endif
