/* Strip Club - Online/Offline Comic Reader/Archiver
 *
 * Copyright notice for this file:
 *  Copyright (C) 2004 Benjamin Cutler
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <SDL/SDL_net.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include "interface.h"
#include "http.h"
#include "url.h"
#include "load.h"

#define	REQ_MAX	2048	// Maximum length of a requests

bool SetIp(IPaddress *ip, const char *Host, Uint16 port, bool Force = false);

void RefreshHostCache() {
	char **Hosts;
	Fl_Preferences *HostCache = new Fl_Preferences(Prefs, "hosts");
	int Num = HostCache->entries();
	Hosts = new char *[Num];
	for (int i = 0; i < Num; i++) {
		clonestr(HostCache->entry(i), (Hosts + i));
	}
	delete HostCache;
	Interface.BarRange(0.0, (float)Num);
	Interface.BarValue(0.0);
	Interface.BarColor(FL_CYAN);
	for (int i = 0; i < Num; i++) {
		SetIp(NULL, Hosts[i], 80, true);
		Interface.BarValue((float)i);
		free(Hosts[i]);
	}
	delete Hosts;
	Interface.BarValue(0.0);
	Interface.BarLabel("");
}

bool SetIp(IPaddress *ip, const char *Host, Uint16 port, bool Force) {
	Fl_Preferences *HostCache = new Fl_Preferences(Prefs, "hosts");
	IPaddress dummy;
	if (!ip) { ip = &dummy; }
	if (HostCache->entryExists(Host) && !Force) {
		char *tmp;
		HostCache->get(Host, tmp, 0);
		sscanf(tmp, "%X", &(ip->host));
		free(tmp);
		DbgOut("Host Cached: %s %08X\n", Host, ip->host);
		ip->port = SDL_SwapBE16(port);
	} else {
		Interface.BarLabel("Looking up host (%s)...", Host);
		if (!SDLNet_ResolveHost(ip, Host, port)) {
			DbgOut("Host Saved%s: %s %08X\n", Force ? " (forced)" : "", Host, ip->host);
			HostCache->set(Host, Fl_Preferences::Name("%08X", ip->host));
			Prefs->flush();
		} else {
			MOut("Unable to resolve host %s!\n", Host);
			return false;
		}
	}
	delete HostCache;
	return true;
}

bool GetRemoteInfo(const sURL *URL, const char *Referer, time_t *ModTime, int *ContentLength, char *ContentType) {
	TCPsocket socket;
	IPaddress ip;	
	SDLNet_SocketSet set;	// For polling if the connection is slow
	char Header[80];
	char Buffer[400];
	char Request[REQ_MAX];
	char month[4];
	char temp;
	int Cur = 0, timeout = 0;
	tm time;

	if (ModTime) {
		*ModTime = 0;
	}
	if (ContentLength) {
		*ContentLength = 0;
	}

	if (!Proxy) {
		if (!SetIp(&ip, URL->Host, atoi(URL->Port))) {
			return false;
		}
	} else {
		if (!SetIp(&ip, Proxy->Host, atoi(Proxy->Port))) {
			return false;
		}
	}

	Interface.BarLabel("Opening connection... (%s)", URL->Host);

	socket = SDLNet_TCP_Open(&ip);

	if (!socket) {
		MOut("SDLNet_TCP_Open: %s\n", SDLNet_GetError());
		return false;
	}

	set = SDLNet_AllocSocketSet(1);

	if (!set) {
		Out("SDLNet_AllocSocketSet: %s\n", SDLNet_GetError());
		SDLNet_TCP_Close(socket);
		return false;
	}

	{
		int headtotal = 0, headcount = 0;
		Prefs->get("headcount", headtotal, 0);
		if (CurComicG) {
			CurComicG->get("headcount", headcount, 0);
		}
		Prefs->set("headcount", ++headtotal);
		if (CurComicG) {
			CurComicG->set("headcount", ++headcount);
		}
	}

	SDLNet_TCP_AddSocket(set, socket);

	DbgOut("Requesting HEAD for URL: %s\n", URL->Full);

	snprintf(Request, REQ_MAX, "HEAD %s HTTP/1.1\r\n", Proxy ? URL->Full : URL->FullPath);

	strcatlim(Request, "Host: ", REQ_MAX);	strcatlim(Request, URL->Host, REQ_MAX);	strcatlim(Request, "\r\n", REQ_MAX);

	if (Referer) {
		strcatlim(Request, "Referer: ", REQ_MAX);
		strcatlim(Request, Referer, REQ_MAX);
		strcatlim(Request, "\r\n", REQ_MAX);
	}

	strcatlim(Request, "User-Agent: ", REQ_MAX);
	if (CurComicG) {
		if (CurComicG->entryExists("useragent")) {
			char UserAgent[80];
			CurComicG->get("useragent", UserAgent, "", 79);
			strcatlim(Request, UserAgent, REQ_MAX);
		} else {
			strcatlim(Request, USERAGENT, REQ_MAX);
		}
	} else {
		strcatlim(Request, USERAGENT, REQ_MAX);
	}
	strcatlim(Request, "\r\n", REQ_MAX);
	strcatlim(Request, "Connection: close\r\n", REQ_MAX);
	if (strcatlim(Request, "\r\n", REQ_MAX)) {	
		// All the other calls will silently and safely fail, but we should check the last one and 
		// kill the program if it blows up, because if we hit this something's gone seriously wrong
		MOut("Fatal error during HEAD request: HTTP request too long!\n" \
		"If you see this message looking at a comic, please file a detailed bug report.\n" \
		"Strip Club will now exit.\n");
		Fl::fatal("Fatal error during HEAD request: HTTP request too long!");
	}

	UOut("Sending HTTP request to: %s (%X)\n", (Proxy ? Proxy : URL)->Host, ip.host);
	UOut(Request);

	Interface.BarLabel("Sending HEAD Request...");

	SDLNet_TCP_Send(socket, (void *)Request, strlen(Request));

	Interface.BarLabel("Awaiting HEAD Response...");

	while(!SDLNet_CheckSockets(set, 100)) { 	// Wait for 1/10th second
		Interface.BarLabel("Awaiting HEAD Response... (%ds)", (++timeout)/10);
	}

	SDLNet_TCP_DelSocket(set, socket);
	SDLNet_FreeSocketSet(set);

	if(SDLNet_TCP_Recv(socket, Header, 17) < 17) {
		MOut("Error retrieving HEAD, connection refused/closed?\n");
		SDLNet_TCP_Close(socket);
		return false;
	} else if (strncmp(Header, "HTTP/1.1 200 OK", 15) && strncmp(Header, "HTTP/1.0 200 OK", 15)) {	// Accept either 1.1 or 1.0 responses
		int i = 17;
		do {
			SDLNet_TCP_Recv(socket, &temp, 1);
			Header[i++] = temp;
		} while((temp != 0xD) && (temp != 0xA));
		Header[i - 1] = '\0';
		MOut("Error retrieving HEAD, expected \"HTTP/1.X 200 OK\" but got \"%s\"\n", Header);
		SDLNet_TCP_Close(socket);
		return false;
	}

	Interface.BarLabel("Receiving HEAD response...");

	Header[17] = '\0';
	DOut("Receiving HEAD response from: %s\n", URL->Host);
	DOut(Header);

	while (SDLNet_TCP_Recv(socket, &temp, 1)) {
		Buffer[Cur++] = temp;
		DOut("%c", temp);
		if (temp == 0xA) {
			if (Cur == 2) { 	// Done
				break;
			}
			sscanf(Buffer, "%s", Header);
			Cur = 0;
			if (!strcmp(Header, "Last-Modified:")) {

				if (ModTime) {
					sscanf((Buffer + strlen(Header)), "%*s %d %3s %d %d:%d:%d", &time.tm_mday, month, &time.tm_year, &time.tm_hour, &time.tm_min, &time.tm_sec);

					time.tm_year -= 1900;		// Struct is expected relative to 1900, but header returns full year
					if (!strcmp(month, "Jan")) {
						time.tm_mon = 0;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Feb")) {
						time.tm_mon = 1;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Mar")) {
						time.tm_mon = 2;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Apr")) {
						time.tm_mon = 3;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "May")) {
						time.tm_mon = 4;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Jun")) {
						time.tm_mon = 5;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Jul")) {
						time.tm_mon = 6;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Aug")) {
						time.tm_mon = 7;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Sep")) {
						time.tm_mon = 8;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Oct")) {
						time.tm_mon = 9;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Nov")) {
						time.tm_mon = 10;
						*ModTime = mktime(&time);
					} else if (!strcmp(month, "Dec")) {
						time.tm_mon = 11;
						*ModTime = mktime(&time);
					} else {
						Out("Invalid Month: %s\n", month);
						*ModTime = 0;
					}	// end Month Block
				}	// if (Modtime)
			} else if (!strcmp(Header, "Content-Length:")) {
				if (ContentLength) {
					sscanf((Buffer + strlen(Header)), "%d", ContentLength);
				}
			} else if (!strcmp(Header, "Content-Type:")) {
				if (ContentType) {
					sscanf(Buffer, "%*s %100[a-zA-Z1-9/]", ContentType);
					DbgOut("ContentType = %s\n",ContentType);
				}
			}
		}	// if (temp == 0xA) (Newline)
	}

	SDLNet_TCP_Close(socket);

	return true;
}

char *GrabHTTPLink(const char *URL, const char *Referer) {
	TCPsocket socket;
	SDLNet_SocketSet set;
	IPaddress ip;
	char Buffer[4096];
	char Request[REQ_MAX];
	static char File[2048];
	sURL *Break;
	char temp;
	char type[100] = "";			// Content-Type
	int filelength, length, done = 0, Cur = 0, timeout = 0;
	int gigsdowntotal = 0, gigsdowncomic = 0, bytesdowntotal = 0, bytesdowncomic = 0;
	time_t localmod, remotemod;
	struct stat filestat;
	char *Return;					// KEEP THIS, otherwise it will try to parse images for links
	static char *TReturn = NULL;	// For the temp files
	FILE *fptr;
	bool body = false, chunked = false;		// Chunked = Chunked Transfer encoding?

	if (!URL || !strlen(URL)) {
		MOut("Null or empty URL passed to GrabHTTPLink(), report this as a bug!\n");
	}

	Interface.BarLabel("");
	Interface.BarRange(0.0f, 0.0f);
	Interface.BarValue(0.0f);
	Interface.BarColor(FL_CYAN);

	Break = URLCreate(URL);

	if(!GetRemoteInfo(Break, Referer, &remotemod, &filelength, type)) {
		Interface.BarLabel("Unable to retrieve HEAD!");
		MOut("Unable to retrieve HEAD for \"%s\"!\n", URL);
		Interface.BarLabel("");
		URLDelete(Break);
		return NULL;
	}

	if (!Proxy) {
		SetIp(&ip, Break->Host, atoi(Break->Port));
	} else {
		SetIp(&ip, Proxy->Host, atoi(Proxy->Port));
	}

	if (!strcmp(type, "image/jpeg") || !strcmp(type, "image/gif") || !strcmp(type, "image/png") ||			// Attempt to id by Content-Type
		!strcmp(Break->Extension, "jpg") || !strcmp(Break->Extension, "gif") || !strcmp(Break->Extension, "png")) {	// And by extension... (goobery ass Userfriendly telling the program a gif is text/html? What the crap?)
		strcpy(File, GetCacheFileName(Break->File));
		Out("Local Filename: %s\n", File);
		if (!stat(File, &filestat)) {		// File exists
			localmod = filestat.st_mtime + timezone;
			DbgOut("Time: Old: %ld %s New: %ld\n", localmod, (localmod >= remotemod) ? ">=" : "< ", remotemod);
			DbgOut("Size: Old: %ld %s New: %ld\n", filestat.st_size, (filestat.st_size == filelength) ? "==" : "!=", filelength);
			if ((localmod >= remotemod) && (remotemod) && (filelength == filestat.st_size)) {		// File is newer or just as recent as the local copy, and remotemod != NULL, and filesizes match
				Interface.BarLabel("Local copy up to date...");
				Out("Local copy up to date\n");
				URLDelete(Break);
				return File;
			}
		}
		if (!(fptr = fopen(File, "wb"))) {		// Rare, but hey
			Interface.BarLabel("Error opening output file!");
			MOut("Error opening \"%s\" for writing!\n", File);
			Interface.BarLabel("");
			return NULL;
		}
		Return = File;
	} else if (!strcmp(Break->Extension, "comic")) {
		strcpy(File, GetCacheFileName(Break->File, true, "comics"));
		if (!(fptr = fopen(File, "wb"))) {		// Rare, but hey
			Interface.BarLabel("Error opening output file!");
			MOut("Error opening \"%s\" for writing!\n", File);
			Interface.BarLabel("");
			return NULL;
		}
		Return = File;
	} else if (!strcmp(type, "text/plain")) {
		free(TReturn);
		clonestr(GetCacheFileName(TEMPTXT, true, "temp"), &TReturn);
		fptr = fopen(TReturn, "wb");
		Return = TReturn;
	} else if (!strncmp(type, "text/html", 9)) {
		free(TReturn);
		clonestr(GetCacheFileName(TEMPHTML, true, "temp"), &TReturn);
		fptr = fopen(TReturn, "wb");
		Return = TReturn;
	} else {		// What the hell are we pointing at?
		return NULL;
	}
	DbgOut("GrabHTTPLink() Return Value: %s\n", Return);

	Interface.BarLabel("Opening connection... (%s)", Break->Host);

	socket = SDLNet_TCP_Open(&ip);

	if (!socket) {
		MOut("SDLNet_TCP_Open: %s\n", SDLNet_GetError());
		URLDelete(Break);
		return NULL;
	}

	{
		int gettotal = 0, getcount = 0;
		Prefs->get("getcount", gettotal, 0);
		if (CurComicG) {
			CurComicG->get("getcount", getcount, 0);
		}
		Prefs->set("getcount", ++gettotal);
		if (CurComicG) {
			CurComicG->set("getcount", ++getcount);
		}
	}

	set = SDLNet_AllocSocketSet(1);

	if (!set) {
		Out("SDLNet_AllocSocketSet: %s\n", SDLNet_GetError());
		SDLNet_TCP_Close(socket);
		URLDelete(Break);
		return NULL;
	}

	SDLNet_TCP_AddSocket(set, socket);

	Interface.BarLabel("Sending GET Request...");

	Out("Requesting URL: %s\n", Break->Full);

	snprintf(Request, REQ_MAX, "GET %s HTTP/1.1\r\n", Proxy ? (Break->Full) : (Break->FullPath));

	if (Referer) {
		strcatlim(Request, "Referer: ", REQ_MAX);
		strcatlim(Request, Referer, REQ_MAX);
		strcatlim(Request, "\r\n", REQ_MAX);
	}

	strcatlim(Request, "User-Agent: ", REQ_MAX);
	if (CurComicG) {
		if (CurComicG->entryExists("useragent")) {
			char UserAgent[80];
			CurComicG->get("useragent", UserAgent, "", 79);
			strcatlim(Request, UserAgent, REQ_MAX);
		} else {
			strcatlim(Request, USERAGENT, REQ_MAX);
		}
	} else {
		strcatlim(Request, USERAGENT, REQ_MAX);
	}
	strcatlim(Request, "\r\n", REQ_MAX);
	strcatlim(Request, "Host: ", REQ_MAX);	strcatlim(Request, Break->Host, REQ_MAX);	strcatlim(Request, "\r\n", REQ_MAX);
	strcatlim(Request, "Connection: close\r\n", REQ_MAX);
	if (strcatlim(Request, "\r\n", REQ_MAX)) {		
		// All the other calls will silently and safely fail, but we should check the last one and 
		// kill the program if it blows up, because if we hit this something's gone seriously wrong
		MOut("Fatal error during GET request: HTTP request too long!\n" \
		"If you see this message looking at a comic, please file a detailed bug report.\n" \
		"Strip Club will now exit.\n");
		Fl::fatal("Fatal error during GET request: HTTP request too long!");
	}

	UOut("Sending HTTP request to: %s\n", Break->Host);
	UOut(Request);

	SDLNet_TCP_Send(socket, (void *)Request, strlen(Request));

	Interface.BarLabel("Awaiting GET Response...");

	while(!SDLNet_CheckSockets(set, 100)) {
		Interface.BarLabel("Awaiting GET Response... (%ds)", (++timeout)/10);
	}

	SDLNet_TCP_DelSocket(set, socket);
	SDLNet_FreeSocketSet(set);

	set = NULL;

	Cur = 0;

	DOut("Receiving GET response from: %s\n", Break->Host);
	Interface.BarLabel("Receiving GET Response...");

	while (!body) {
		if (SDLNet_TCP_Recv(socket, &temp, 1) <= 0) {
			MOut("Error retrieving URL: %s\n", SDLNet_GetError());
			SDLNet_TCP_Close(socket);
			URLDelete(Break);
			return NULL;
		}
		Buffer[Cur++] = temp;
		DOut("%c", temp);
		if (temp == 0xA) {
			if (Cur == 2) { 
				body = true; 
			} else {
				char Header[80], Encoding[80];
				sscanf(Buffer, "%79s %79s", Header, Encoding);
				if (!strcmp(Header, "Transfer-Encoding:") && !strcmp(Encoding, "chunked")) { // "Transfer-Encoding: chunked"
					chunked = true;
				}
			}
			Cur = 0;
		}
	};

	DbgOut("Now receiving body\n");

	if (chunked) {
		DbgOut("Chunked transfer\n");
	}

	Interface.BarLabel("");

	Prefs->get("gigsdown", gigsdowntotal, 0);
	Prefs->get("bytesdown", bytesdowntotal, 0);
	if (CurComicG) {
		CurComicG->get("gigsdown", gigsdowncomic, 0);
		CurComicG->get("bytesdown", bytesdowncomic, 0);
	}

	if (Debug) {
		DbgOut("gigsdowntotal: %d bytesdowntotal: %d gigsdowncomic: %d bytesdowncomic: %d\n", gigsdowntotal, bytesdowntotal, gigsdowncomic, bytesdowncomic);
	}

	if (filelength) {
		Interface.BarRange(0.0f, (float)filelength);
		DbgOut("File Length: %ld\n", filelength);
		if (!chunked) {
			do {
				length = SDLNet_TCP_Recv(socket, Buffer, 4096);
				if (length > 0) {
					fwrite(Buffer, 1, length, fptr);
					done += length;
					bytesdowntotal += length;
					bytesdowncomic += length;
					if (bytesdowncomic >= (1024*1024*1024)) {
						gigsdowncomic++;
						bytesdowncomic -= (1024*1024*1024);
					}
					if (bytesdowntotal >= (1024*1024*1024)) {
						gigsdowntotal++;
						bytesdowntotal -= (1024*1024*1024);
					}
					Interface.BarLabel("%s %d/%d (%d%%)", strlen(Break->File) ? Break->File : "index.html", done, filelength, done*100/filelength);
					Interface.BarValue((float)done);
				}
			} while ((done < filelength) && (length > 0));
		} else {
			int chunklength, chunkdone;
			char chunkheader[16], tmp;
			do {
				do {
					length = SDLNet_TCP_Recv(socket, &tmp, 1);
					if (length < 1) {		// Connection broken
						MOut("Error: Connection closed before done receiving body\n");
						break;
					}
					chunkheader[Cur++] = tmp;
				} while (tmp != 0xA);
				chunkheader[Cur] = 0; 		// End string
				Cur = 0;
				sscanf(chunkheader, "%x", &chunklength);
				chunkdone = 0;
				DbgOut("Chunkheader: %s", chunkheader);		// Because the chunkheader has it's own newline
				DbgOut("Chunklength: %d", chunklength);
				if (!chunklength) {		// Hit the last chunk
					done = length;
					SDLNet_TCP_Close(socket);
					socket = NULL;
					DbgOut("Closed Socket\n");
				}
				while (chunkdone < chunklength) {
					length = SDLNet_TCP_Recv(socket, Buffer, min(chunklength - chunkdone, 4096));
					if (length < 1) {		// Connection broken
						MOut("Error: Connection closed before done receiving body\n");
						break;
					}
					chunkdone += length;
					done += length;
					bytesdowntotal += length;
					bytesdowncomic += length;
					if (bytesdowncomic >= (1024*1024*1024)) {
						gigsdowncomic++;
						bytesdowncomic -= (1024*1024*1024);
					}
					if (bytesdowntotal >= (1024*1024*1024)) {
						gigsdowntotal++;
						bytesdowntotal -= (1024*1024*1024);
					}
					Interface.BarLabel("%s %d/%d (%d%%)", strlen(Break->File) ? Break->File : "index.html", done, filelength, done*100/filelength);
					Interface.BarValue((float)done);
					fwrite(Buffer, 1, length, fptr);
				}
				if (socket) {
					SDLNet_TCP_Recv(socket, Buffer, 2);	// Read the CRLF an the end of the chunk
				}
			} while ((done < filelength) && (length > 0));
		}
		Interface.BarValue(0.0f);
	} else {
		if (!chunked) {
			do {
				length = SDLNet_TCP_Recv(socket, Buffer, 4096);
				if (length > 0) {
						fwrite(Buffer, 1, length, fptr);
						done += length;
						bytesdowntotal += length;
						bytesdowncomic += length;
						if (bytesdowncomic >= (1024*1024*1024)) {
							gigsdowncomic++;
							bytesdowncomic -= (1024*1024*1024);
						}
						if (bytesdowntotal >= (1024*1024*1024)) {
							gigsdowntotal++;
							bytesdowntotal -= (1024*1024*1024);
						}
						Interface.BarLabel("%s %d", strlen(Break->File) ? Break->File : "index.html", done);
				}
			} while (length > 0);
		} else {
			bool chunkalldone = false;
			int chunklength, chunkdone;
			char chunkheader[16], tmp;
			do {
				do {
					length = SDLNet_TCP_Recv(socket, &tmp, 1);
					if (length < 1) {		// Connection broken
						MOut("Error: Connection closed before done receiving body\n");
						break;
					}
					chunkheader[Cur++] = tmp;
				} while (tmp != 0xA);
				chunkheader[Cur] = 0; 		// End string
				Cur = 0;
				sscanf(chunkheader, "%x", &chunklength);
				chunkdone = 0;
				DbgOut("Chunkheader: %s", chunkheader);		// Because the chunkheader has it's own newline
				DbgOut("Chunklength: %d\n", chunklength);
				if (!chunklength) {		// Hit the last chunk
					chunkalldone = true;
					SDLNet_TCP_Close(socket);
					socket = NULL;
					DbgOut("Closed Socket\n");
				}
				while (chunkdone < chunklength) {
					length = SDLNet_TCP_Recv(socket, Buffer, min(chunklength - chunkdone, 4096));
					if (length < 1) {		// Connection broken
						MOut("Error: Connection closed before done receiving body\n");
						break;
					}
					done += length;
					chunkdone += length;
					bytesdowntotal += length;
					bytesdowncomic += length;
					if (bytesdowncomic >= (1024*1024*1024)) {
						gigsdowncomic++;
						bytesdowncomic -= (1024*1024*1024);
					}
					if (bytesdowntotal >= (1024*1024*1024)) {
						gigsdowntotal++;
						bytesdowntotal -= (1024*1024*1024);
					}
					Interface.BarLabel("%s %d", strlen(Break->File) ? Break->File : "index.html", done);
					fwrite(Buffer, 1, length, fptr);
				}
				if (socket) {
					SDLNet_TCP_Recv(socket, Buffer, 2);	// Read the CRLF an the end of the chunk
				}
			} while ((!chunkalldone) && (length > 0));
		}
	}

	Prefs->set("gigsdown", gigsdowntotal);
	Prefs->set("bytesdown", bytesdowntotal);
	if (CurComicG) {
		CurComicG->set("gigsdown", gigsdowncomic);
		CurComicG->set("bytesdown", bytesdowncomic);
	}

	if (Debug) {
		DbgOut("gigsdowntotal: %d bytesdowntotal: %d gigsdowncomic: %d bytesdowncomic: %d\n", gigsdowntotal, bytesdowntotal, gigsdowncomic, bytesdowncomic);
	}

	if (length < 0) {	// Rare, but just in case...
		MOut("SDLNet_TCP_Recv: %s\n", SDLNet_GetError());
	}

	fclose(fptr);

	Interface.BarLabel("");

	Out("Done with Request\n");

	if (socket) {
		SDLNet_TCP_Close(socket);
		socket = NULL;
		DbgOut("Closed Socket\n");
	}

	URLDelete(Break);

	DbgOut("Returning: %s\n", Return);

	return Return;
}
