/***************************************************************************
 *   Copyright (C) 2004 by Fred Schaettgen                                 *
 *   kde.sch@ttgen.net                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef STYLECONFIGDLG_H
#define STYLECONFIGDLG_H

#include <kconfigdialog.h>
#include <map>

class StyleConfigWidget;
class Prefs;
class ClockPaintView;

/**
@author Fred Schaettgen
*/
class StyleConfigDialog : public KConfigDialog
{
Q_OBJECT
public:
    StyleConfigDialog(QWidget *parent, Prefs *prefs, ClockPaintView* clock);   
    ~StyleConfigDialog();
    StyleConfigWidget* styleWidget;

private:
    Prefs* prefs;
    ClockPaintView* clock;
    
private slots:
    void slotSaveCurrentProperty();
    void refreshCurrentProperty();
protected:
    virtual bool hasChanged();
    virtual void updateSettings();
    void updatePropertyList();
    std::map<QString,QString> props;
};

#endif
