/*
 * Copyright (C) 2004 Fred Schaettgen <Sch@ttgen.net>
 */

#include "fashionclockview.h"

#include <qpainter.h>
#include <qlayout.h>

#include <kurl.h>

#include <ktrader.h>
#include <klibloader.h>
#include <kmessagebox.h>
#include <krun.h>
#include <klocale.h>
#include "../styleclockwidget/clockpaintview.h"

FashionClockView::FashionClockView(QWidget *parent, Prefs* prefs)
    : QWidget(parent), FashionClockIface()
{
    // setup our layout manager to automatically add our widgets
    QHBoxLayout *top_layout = new QHBoxLayout(this);
    top_layout->setAutoAdd(true);

    m_clock = new ClockPaintView(this, this, prefs);

}

QDateTime FashionClockView::getAlarmTime()
{
    return QDateTime::currentDateTime();
}


FashionClockView::~FashionClockView()
{
}

void FashionClockView::print(QPainter */*p*/, int /*height*/, int /*width*/)
{
    // do the actual printing, here
    // p->drawText(etc..)
}

QString FashionClockView::currentURL()
{
    return "";
}

void FashionClockView::openURL(QString url)
{
    openURL(KURL(url));
}

void FashionClockView::openURL(const KURL& /*url*/)
{
    //m_html->openURL(url);
}

#include "fashionclockview.moc"
