/* ------------------------------------------------------------------------ */
/*                                                                          */
/* [ctx.h]                     Program Context                              */
/*                                                                          */
/* Copyright (c) 1993 by D\olle, Manns                                      */
/* ------------------------------------------------------------------------ */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef ctx_INCL
#define ctx_INCL


#include "ctx_app.h"


#ifdef __cplusplus
extern "C" {
#endif


/* 
   <p>This module [ctx] provides functions for the definition of a program context and
   the verification of the current commandline against the current program context.

   <p>The definition interface will be used by the <a href="cmdlib.htm">CMD Compiler</a>
   which parses and evaluates a command decription file [.cmd], constructs a program context
   out of it and finally makes it persistent.

   <p>The application interface will be used by the applications and the generated
   program specific context modules.
   <br>
*/

/* ------------------------ Definition interface -------------------------- */

CTX_T CTX_new(short cnt, c_string name)
/* make new context for program 'name' and 'cnt' arguments */
;

void     CTX_free(CTX_T ctx);          /* drop context 'ctx'                */

void  CTX_set
      (
        CTX_T ctx, short idx, c_string ide,
        c_byte cat, c_byte typ, c_string dft
      )
/* assign argument 'ide' of category 'cat', with type 'typ' and
   default value 'dft' to context entry ctx[idx]
*/
;

void  CTX_put(c_string env, CTX_T ctx)
/* put binary image of context 'ctx' */
;

CTX_T CTX_get(c_string env, c_string name)
/* get context from binary image [$'env'/'name'.cim] */
;

void     CTX_usage(CTX_T ctx);         /* print usage for context 'ctx'     */

void CTX_C_Modul(c_string Environ, CTX_T Ctx, c_bool shortform)
/* compiles context 'ctx' to [$'Environ'/'Name'_cim.c] */
;

void     CTX_sh_list(void);            /* print shell context               */
void     CTX_list(CTX_T ctx);          /* DEBUG; print context 'ctx'        */
c_string CTX_dirname(void);            /* path of the current program       */

void CTX_interprete(int argc, c_string argv[])
/* process current program context */
;


/* ------------------------ Application interface ------------------------- */

void CTX_init(int argc, c_string argv[])
/* initialize and process current program context */
;

void CTX_quit(void);                   /* drop current program context      */


#ifdef __cplusplus
}
#endif

#endif
