/* ---------------------------------------------------------------------- */
/*                                                                        */
/* [gls.h]               Generic Language Support                         */
/*                                                                        */
/* Copyright (c) 1994 by Lars D\olle, Heike Manns                         */
/* ---------------------------------------------------------------------- */

/* File generated by 'ctoh'. Don't change manually. */

#ifndef gls_INCL
#define gls_INCL


#include "standard.h"
#include "ptm.h"


#ifdef __cplusplus
extern "C" {
#endif


/*  
   [gls] provides a generic interface for the token and nonterminal lists of
   the abstract derivation trees in the generated grammar-specific interface
   modules ( <Language>_int.c ).

   Beside that this module provides generic access to an optional token or
   nonterminal (styx version >= 1).
*/

/* ------------------------------ Types ----------------------------------- */

#define GLS_Lst(A) GList_T
#define GLS_Opt(A) GOpt_T

AbstractType( GLS_Tok );    // Abstract token type
AbstractType( GLS_Lst(A) ); // Abstract term list type
AbstractType( GLS_Opt(A) ); // Abstract term option type

/* ------------------------------ Init ----------------------------------- */

void GLS_init(void);                   /* module initialisation             */

/* --------------------------- Normalizer --------------------------------- */

/* 
  <p> <b>... to skip comments, keywords and ignore-nodes </b>
      <br>moved to <a href="ptm.htm">[ptm]</a>
*/

#define XGLS_keycom_Skip XPT_keycom_Skip
#define GLS_keycom_Skip  PT_keycom_Skip
#define GLS_ign_Skip     PT_ign_Skip

/* -------------------------- Token services ------------------------------ */

PT_Term  GLS_Tok_cfg(GLS_Tok x);       /* the embedded lanuage of token 'x' */
symbol   GLS_Tok_symbol(GLS_Tok x);    /* the symbol of token 'x'           */
c_string GLS_Tok_string(GLS_Tok x);    /* the string value of token 'x'     */
c_bool GLS_Term_Tok(PT_Term x, GLS_Tok *t); /* Term to token selector       */

/* --------------------------- List Construction -------------------------- */

PT_Term GLS_Lst_nil_mk(void);                  /* nil production            */
PT_Term GLS_Lst_cons_mk(PT_Term a, PT_Term b); /* cons production           */
PT_Term XGLS_Lst_nil_mk(void);                 /* nil production (xaron)    */

PT_Term XGLS_Lst_cons_mk(PT_Term a, GLS_Lst(PT_Term) *b)
/* cons production (xaron ALT? Speculate?) */
;

PT_Term X4GLS_Lst_cons_mk(PT_Term a, GLS_Lst(PT_Term) *b)
/* cons production (xaron) */
;


/* --------------------------- List service -------------------------------- */

c_bool GLS_Term_Lst(PT_Term x, GLS_Lst(PT_Term) *lst)
/* Term to GLS_Lst selector */
;

c_bool GLS_Lst_nil(GLS_Lst(PT_Term) x)
#define GLS_EMPTY(term) ( GLS_Lst_nil((PT_Term)(term)) )
/* nil - selector */
;

c_bool GLS_Lst_cons(GLS_Lst(PT_Term) x, PT_Term* fst_t, GLS_Lst(PT_Term)* rst_t)
/* cons - selector */
;

PT_Term GLS_Lst_first(GLS_Lst(PT_Term) x)
#define GLS_FIRST(type,term) ( (type)GLS_Lst_first((GLS_Lst(PT_Term))(term)) )
/* first element in list 'x' */
;

PT_Term GLS_Lst_rest(GLS_Lst(PT_Term) x)
#define GLS_REST(type,term) \
        ( (GLS_Lst(type))GLS_Lst_rest((GLS_Lst(PT_Term))(term)) )
/* remaining elements in list 'x' */
;

int GLS_Lst_length(GLS_Lst(PT_Term) x)
#define GLS_LENGTH(term) ( GLS_Lst_length((GLS_Lst(PT_Term))(term)) )
/* length of list 'x' */
;

PT_Term GLS_Lst_nth(GLS_Lst(PT_Term) x, int nth)
#define GLS_NTH(type,term,nth) ((type)GLS_Lst_nth((GLS_Lst(PT_Term))(term),nth))
/* nth element in list 'x' ( nth >= 1 ) */
;


/* --------------------------- Option service ------------------------------ */

c_bool GLS_Term_Opt(PT_Term x, GLS_Opt(PT_Term) *opt)
/* Term to GLS_Opt selector */
;

c_bool GLS_Opt_none(GLS_Opt(PT_Term) x)
#define GLS_OPT_NONE(term) ( GLS_Opt_none((PT_Term)(term)) )
/* none - selector */
;

c_bool GLS_Opt_some(GLS_Opt(PT_Term) x)
#define GLS_OPT_SOME(term) ( GLS_Opt_some((PT_Term)(term)) )
/* some - selector */
;

PT_Term GLS_Opt_term(GLS_Opt(PT_Term) x)
#define GLS_OPT_TERM(type,term) ( (type)GLS_Opt_term((GLS_Opt(PT_Term))(term)) )
/* element in option 'x' */
;


/* ---------------------- Convenient iterator macros ----------------------- */

#define GLS_FORALL(it,li)      for( (it) = ((PT_Term)(li));  \
                                   ! GLS_EMPTY(it);          \
                                   it = GLS_REST(PT_Term,it) )

#define GLS_FORALLI(it,li,c)   for( c=0, (it) = ((PT_Term)(li));  \
                                   ! GLS_EMPTY(it);               \
                                   ++c, it = GLS_REST(PT_Term,it) )


#ifdef __cplusplus
}
#endif

#endif
