/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DIFFDIALOG_H
#define _SC_DIFFDIALOG_H

// sc
#include "sublib/TargetId.h"
class RevisionWidget;
class DiffParam;
class ExternProvider;
class BaseModel;
class FontSettings;
namespace svn
{
  class Revision;
}

// qt
#include <qdialog.h>
class QComboBox;
class QCheckBox;
class QPushButton;
class QLabel;
class QListView;
class QListViewItem;

// sys
#include <vector>


class DiffDialog : public QWidget, public TargetId
{
  typedef QWidget super;
  Q_OBJECT 

public:
  typedef std::vector<DiffParam*> DiffParams;

public:
  DiffDialog( BaseModel* model, bool folder, ExternProvider* p, QWidget *parent = 0 );
  virtual ~DiffDialog();

  void customEvent( QCustomEvent* ce );

  void setPathOrUrl1( const QString& pathOrUrl1 );
  void setPathOrUrl2( const QString& pathOrUrl2 );
  void setRevision1( const svn::Revision* );
  void setRevision2( const svn::Revision* );

  void enablePathOrUrl1( bool enable );
  void enablePathOrUrl2( bool enable );

  enum DiffType {
    Diff,
    Patch,
    Summarize
  };

  DiffParam* getParameters( DiffType type );
  void getParameters( DiffParams& params );
  FontSettings* getFontSettings() const;
  QListView* getListView() const;
  bool isFolder() const;

public slots:
  void checkButtons( const QString& text );
  void doubleClicked( QListViewItem*, const QPoint&, int );

signals:
  void diff();
  void patch();
  void summarize();
  void closed();

private slots:
  void xdiff();
  void xpatch();
  void xsum();
  void xclose();

  void selectRep1Url();
  void selectRep2Url();
  void changedDiffType( bool );

public slots:
  void enableButtons();

private: 
  BaseModel*      _model;
  ExternProvider* _p;

  bool            _folder;

  QComboBox*      _rep1;
  QLabel*         _rep1L;
  QPushButton*    _rep1B;

  QCheckBox*      _type;
  QComboBox*      _rep2;
  QLabel*         _rep2L;
  QPushButton*    _rep2B;

  RevisionWidget* _rwPeg;
  RevisionWidget* _rw1;
  RevisionWidget* _rw2;

  QCheckBox*      _recurse;
  QCheckBox*      _ancestry;
  QCheckBox*      _deleted;

  QListView*      _summarize;

  QPushButton*    _diff;
  QPushButton*    _sum;
  QPushButton*    _patch;
};

#endif // _SC_DIFFDIALOG_H
