/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "LockDialog.h"
#include "WcModel.h"
#include "ScModel.h"
#include "TextEdit.h"
#include "settings/FontSettings.h"
#include "sublib/Gui.h"
#include "util/String.h"

// qt
#include <qlayout.h>
#include <qgroupbox.h>
#include <qpushbutton.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qtextedit.h>
#include <qvbox.h>



LockDialog::LockDialog( ScModel* model, QWidget *parent )
: super( parent, 0, true, Qt::WStyle_Customize | Qt::WStyle_Dialog |
  Qt::WStyle_NormalBorder | Qt::WStyle_Title | Qt::WStyle_SysMenu ), _model(model)
{
  setCaption( _q("subcommander:lock") );

  QVBoxLayout *vbl = new QVBoxLayout(this,5,8);
  vbl->setSpacing(10);
  {
    QGroupBox* gb = new QGroupBox(1,Qt::Vertical,this);
    gb->setTitle( _q("lock options: ") );
    gb->setInsideMargin(0);
    gb->setFlat(true);
    vbl->addWidget(gb);

    QFont font = _model->getFontSettings()->getEditorFont();
    QFontMetrics m(font);

    _edit = new TextEdit(this);
    _edit->setFont( font );
    _edit->setUndoRedoEnabled(true);
    _edit->setTabChangesFocus(true);
    _edit->setSizePolicy( QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding) );
    _edit->setMinimumWidth( 500 );
    _edit->setWordWrap( QTextEdit::NoWrap );
    vbl->addWidget(_edit);

    _pos = new QLabel(this);
    vbl->addWidget(_pos);

    connect( _edit, SIGNAL(cursorChanged(int,int)), SLOT(cursorChanged(int,int)) );


    QHBoxLayout* h1 = new QHBoxLayout;
    vbl->addLayout(h1);
    {
      _steal = new QCheckBox(_q("&steal locks"),this);
      _steal->setChecked(model->getOptionCommandForce());
      h1->addWidget(_steal);
    }

    QHBoxLayout* hu = new QHBoxLayout;
    vbl->addLayout(hu);
    {
      // eats extra space, so the buttons keep their size
      hu->addStretch(1); 

      _ok = new QPushButton(this);
      _ok->setEnabled(true);
      _ok->setText( _q("&Lock") );
      _ok->setDefault(true);
      hu->addWidget(_ok);
      QPushButton* ca = new QPushButton(this);
      ca->setText( _q("&Cancel") );
      hu->addWidget(ca);

      hu->addSpacing(getSizeGripSpacing());
      
      connect( _ok, SIGNAL(clicked()), SLOT(accept()) );
      connect( ca, SIGNAL(clicked()), SLOT(reject()) );
    }
  }
}

LockDialog::~LockDialog()
{
}

QString LockDialog::getLogMessage() const
{
  return _edit->text();
}

bool LockDialog::isStealLock() const
{
  return _steal->isChecked();
}

void LockDialog::cursorChanged( int x, int y )
{
  _pos->setText( QString(_q("Line: %1  Column: %2")).arg(y+1,3).arg(x+1,3) );
}
