/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "AddCmd.h"
#include "AddParam.h"
#include "CmdResultCallback.h"
#include "CmdProgressCallback.h"
#include "svn/Client.h"


AddCmd::AddCmd( AddParam* param, CmdResultCallback* cb )
: ScCmd(param->getId()), _param(param), _cb(cb)
{
}

AddCmd::~AddCmd()
{
  delete _cb;
}

void AddCmd::run()
{
  sc::Error* err;

  _prgscb->started( getId(), _param, getCancel() );

  err = _client->add( _param->getPaths(), _param->getRecurse(), _param->getForce() );

  _param->setError( err );
  _prgscb->finished( getId(), _param );

  _cb->handleResult( _param, err );
}
