/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ScParam.h"
#include "ScCmdData.h"

ScParam::ScParam() : _id(Id::next()), _cmdData(0), _error(sc::Success)
{
}

ScParam::~ScParam()
{
  delete _cmdData;
}

ID ScParam::getId()
{
  return _id;
}

void ScParam::setCmdData( ScCmdData* d )
{
  _cmdData = d;
}

ScCmdData* ScParam::getCmdData() const
{
  return _cmdData;
}

void ScParam::setError( const sc::Error* err )
{
  _error = err;
}

const sc::Error* ScParam::getError() const
{
  return _error;
}

bool ScParam::hasError() const
{
  return _error != sc::Success;
}
