/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "CopyDialogCmd.h"
#include "../CopyDialog.h"
#include "../ExternProviderImpl.h"
#include "../BaseModel.h"
#include "../PostCmdResult.h"

CopyDialogCmd::CopyDialogCmd( QWidget* parent, ID tid, BaseModel* model )
: _parent(parent), _tid(tid), _model(model)
{
}

void CopyDialogCmd::run( const QString& src, const QString& dst )
{
  ExternProviderImpl externProvider(_model);
  
  CopyDialog* cpdlg = new CopyDialog( &externProvider, _parent );

  // no dst given, then preset with src
  QString tdst = src.isEmpty() ? src : dst;
  
  cpdlg->setSrcPathOrUrl(src);
  cpdlg->setDstPathOrUrl(tdst);
  cpdlg->enableSrc(false);
  cpdlg->enableDst(true);

  int result = cpdlg->exec();

  if( result != QDialog::Accepted )
  {
    return;
  }

  CopyParam*     param = cpdlg->getParameters();
  PostCmdResult* pcres = new PostCmdResult(_tid);

  delete cpdlg;
  
  _model->copy( param, pcres );
}
