/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COPYDIALOGCMD_H
#define _SC_COPYDIALOGCMD_H

// sc
#include "util/Id.h"
class BaseModel;

// qt
#include <qstring.h>
class QWidget;
class QObject;

/**
 * Helper class to run a dialog based copy.
 */ 
class CopyDialogCmd
{
public:
  CopyDialogCmd( QWidget* parent, ID tid, BaseModel* model );

  void run( const QString& src, const QString& dst );

private:
  QWidget*   _parent;
  ID         _tid;
  BaseModel* _model;
};

#endif // _SC_COPYDIALOGCMD_H
