/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_DEBUGSETTINGSINFO_H
#define _SC_DEBUGSETTINGSINFO_H

// sc
#include "sublib/settings/SettingsInfoBase.h"
class SettingsWidget;
class DebugSettings;

// qt
#include <qstring.h>


class DebugSettingsInfo : public SettingsInfoBase
{
public:
  DebugSettingsInfo( const QString& title, const QString& id, DebugSettings* dbg, int sortIndex );
  ~DebugSettingsInfo();

  const QString& getTitle();
  const QString& getSettingsId();

  void initWidgetData( SettingsWidget* sw );
  void storeWidgetData( SettingsWidget* sw );
  
  bool isModified();

  void ok();
  void apply();
  void cancel();

  int getSortIndex();

private:
  QString  _title;
  QString  _id;

  DebugSettings* _dbg;

  bool     _log;
  bool     _l10n;

  int      _sortIndex;
};

#endif //  _SC_PROJECTSETTINGSINFO_H
