/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */
 
// sc
#include "Utility.h"

// qt
#include <qmessagebox.h>
#include <qpixmap.h>


int msgInformation( const QString& caption, const QString& text,
  const QString& button0, const QString& button1 )
{
  QMessageBox msg( caption, text, QMessageBox::Warning,
    button0.isNull() ? QMessageBox::NoButton : QMessageBox::Ok     | QMessageBox::Default,
    button1.isNull() ? QMessageBox::NoButton : QMessageBox::Cancel | QMessageBox::Escape, 
    QMessageBox::NoButton );

  msg.setIconPixmap( QPixmap(getIconDir() + "MessageBox-Information.png") );

  if( ! button0.isNull() )
    msg.setButtonText( QMessageBox::Ok,     button0 );
  if( ! button1.isNull() )
    msg.setButtonText( QMessageBox::Cancel, button1 );

  return msg.exec();
}


int msgWarning( const QString& caption, const QString& text,
  const QString& button0, const QString& button1 )
{
  QMessageBox msg( caption, text, QMessageBox::Warning,
    button0.isNull() ? QMessageBox::NoButton : QMessageBox::Ok     | QMessageBox::Default,
    button1.isNull() ? QMessageBox::NoButton : QMessageBox::Cancel | QMessageBox::Escape, 
    QMessageBox::NoButton );

  msg.setIconPixmap( QPixmap(getIconDir() + "MessageBox-Warning.png") );

  if( ! button0.isNull() )
    msg.setButtonText( QMessageBox::Ok,     button0 );
  if( ! button1.isNull() )
    msg.setButtonText( QMessageBox::Cancel, button1 );

  return msg.exec();
}


int msgCritical( const QString& caption, const QString& text,
  const QString& button0, const QString& button1 )
{
  QMessageBox msg( caption, text, QMessageBox::Warning,
    button0.isNull() ? QMessageBox::NoButton : QMessageBox::Ok     | QMessageBox::Default,
    button1.isNull() ? QMessageBox::NoButton : QMessageBox::Cancel | QMessageBox::Escape, 
    QMessageBox::NoButton );

  msg.setIconPixmap( QPixmap(getIconDir() + "MessageBox-Critical.png") );

  if( ! button0.isNull() )
    msg.setButtonText( QMessageBox::Ok,     button0 );
  if( ! button1.isNull() )
    msg.setButtonText( QMessageBox::Cancel, button1 );

  return msg.exec();
}
