/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SETTINGSINFO_H
#define _SC_SETTINGSINFO_H

// sc
class SettingsWidget;

// qt
class QString;


class SettingsInfo
{
public:
  virtual ~SettingsInfo() {}

  virtual const QString& getTitle() = 0;
  virtual const QString& getSettingsId() = 0;
  virtual void  initWidgetData( SettingsWidget* sw ) = 0;
  virtual void  storeWidgetData( SettingsWidget* sw ) = 0;

  virtual bool isModified() = 0;

  virtual void ok() = 0;
  virtual void apply() = 0;
  virtual void cancel() = 0;

  virtual int getSortIndex() = 0;

  virtual void setSelected( const QString& title ) = 0;
  virtual bool getSelected() = 0;
};


#endif //  _SC_SETTINGSINFO_H
