/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_COLORSETTINGSWIDGET_H
#define _SC_COLORSETTINGSWIDGET_H

// sc
#include "ColorSettings.h"
#include "sublib/SettingsWidget.h"

// qt
class QListView;
class QListViewItem;
class QLabel;


class ColorSettingsWidget : public SettingsWidget
{
  typedef SettingsWidget super;
  Q_OBJECT;

public:
  ColorSettingsWidget( QWidget *parent = 0 );
  ~ColorSettingsWidget();

  void setColors( const Colors& );
  void getColors( Colors& );

public slots:
  void doubleClicked( QListViewItem*, const QPoint&, int );
  void clicked( QListViewItem* );

private:
  QListView* _clist;
  QLabel*    _desc;
};


#endif // _SC_COLORSETTINGSWIDGET_H
