/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "ErrorImpl.h"
#include "svn.h"

// svn
#include <svn_error.h>


namespace svn
{

ErrorImpl::ErrorImpl( svn_error_t* e ) : _error(e)
{
}

ErrorImpl::~ErrorImpl()
{
  svn_error_clear(_error);
}

long ErrorImpl::getCode() const
{
  return _error->apr_err;
}

sc::String ErrorImpl::getMessage( svn_error_t* err ) const
{
  sc::String msg;

  if( err->message )
  {
    msg = err->message;
  }
  else
  {
    char buf[1024] = {};
    char*b = svn_strerror( err->apr_err, buf, 1020 );
    if( b )
    {
      msg = apr_pstrdup( err->pool, buf );
    }
    else
    {
      msg = apr_itoa( err->pool, err->apr_err );
    }
  }

  return msg;
}

sc::String ErrorImpl::getMessage() const
{
  return getMessage(_error);
}

sc::String ErrorImpl::getMessages() const
{
  sc::String msg = getMessage(_error);

  svn_error_t* ce = _error->child; 
  while( ce )
  {
    msg += "\n";
    msg += getMessage(ce);

    ce = ce->child;
  }
  return msg;
}

const sc::Error* ErrorImpl::getNested() const
{
  if( ! _error->child )
  {
    return 0;
  }

  return new ErrorImpl( svn_error_dup(_error->child) );
}

svn_error_t* ErrorImpl::getError() const
{
  return _error;
}


} // namespace
