/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_STACKFRAME_H
#define _SC_STACKFRAME_H

// sc
#include "String.h"

// apr
#include <apr.h>

// sys
#include <vector>


class Stackframe
{
public:
  Stackframe();

public:
  bool         _error;

  apr_uint64_t _addr;
  apr_uint32_t _addrSeg;

  bool         _symbol;
  sc::String   _symbolName;
  apr_uint64_t _symbolDisp;

  bool         _module;
  sc::String   _moduleName;

  bool         _line;
  sc::String   _fileName;
  long         _lineNr;
  long         _lineDisp;
};


typedef std::vector<Stackframe>  Stackframes;

#endif // SC_STACKFRAME_H
