/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */

#include "ISubtitleEditor.h"
#include "DialogChangeFPS.h"

/*
 *
 */
DialogChangeFPS::DialogChangeFPS(BaseObjectType* cobject, const Glib::RefPtr<Gnome::Glade::Xml>& refGlade)
:Gtk::Dialog(cobject)
{
	refGlade->get_widget_derived("combo-src", m_comboSrc);
	refGlade->get_widget_derived("combo-dest", m_comboDest);

	m_comboSrc->get_entry()->signal_activate().connect(
			sigc::bind<ComboBoxEntryText*>(
				sigc::mem_fun(*this, &DialogChangeFPS::combo_activate), m_comboSrc));

	m_comboDest->get_entry()->signal_activate().connect(
			sigc::bind<ComboBoxEntryText*>(
				sigc::mem_fun(*this, &DialogChangeFPS::combo_activate), m_comboDest));


	//if(key)
	{
	}
	//else
	{
		m_comboSrc->append_text(to_string(23.976));
		m_comboSrc->append_text(to_string(25.000));
		m_comboSrc->append_text(to_string(29.970));

		m_comboDest->append_text(to_string(23.976));
		m_comboDest->append_text(to_string(25.000));
		m_comboDest->append_text(to_string(29.970));
	}

	m_comboSrc->set_active(0);
	m_comboDest->set_active(1);
}

/*
 * 
 */
double DialogChangeFPS::get_source()
{
	Glib::ustring text = m_comboSrc->get_active_text();

	double value = 0;
	
	if(from_string(text, value))
		return value;
	return 0;
}


/*
 *
 */
double DialogChangeFPS::get_dest()
{
	Glib::ustring text = m_comboDest->get_active_text();

	double value = 0;
	
	if(from_string(text, value))
		return value;
	return 0;
}

/*
 *
 */
void DialogChangeFPS::execute()
{
	Document *doc = SE::getInstance()->getDocument();
	g_return_if_fail(doc);
	
	show();
	
	if(run() == Gtk::RESPONSE_OK)
	{
		double src = get_source();
		double dest = get_dest();

		if(src!=0 && dest!=0)
		{
			doc->get_subtitle_model()->changeFPS(src,dest);
			SE::getInstance()->setStatusbar(_("Change FPS: %f -> %f"), src, dest);
		}
		//else
		//	dialog_error(_("Change FPS error."), _("your current or new framerate is not valid."));  
	}

	hide();
}

void DialogChangeFPS::combo_activate(ComboBoxEntryText *combo)
{
	Glib::ustring text = combo->get_entry()->get_text();

	double value = 0;
	if(from_string(text, value))
	{
		if(value > 0)
		{
			combo->append_text(to_string(value));
			combo->set_active_text(to_string(value));

			return;
		}
	}

	combo->set_active(0);
}

